/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.api.events.PostTransactionEvent;
import me.gypopo.economyshopgui.api.events.PreTransactionEvent;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.CreateItem;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.objects.MainMenu;
import me.gypopo.economyshopgui.objects.SellGUI;
import me.gypopo.economyshopgui.objects.ShopInventory;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.objects.ShopPage;
import me.gypopo.economyshopgui.objects.ShopSection;
import me.gypopo.economyshopgui.objects.TransactionMenu;
import me.gypopo.economyshopgui.objects.TransactionMenus;
import me.gypopo.economyshopgui.util.PermissionsCache;
import me.gypopo.economyshopgui.util.Transaction;
import me.gypopo.economyshopgui.util.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class MenuHandler
implements Listener {
    private final EconomyShopGUI plugin;

    public MenuHandler(EconomyShopGUI plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onMenuClick(InventoryClickEvent e) {
        block44: {
            InventoryHolder holder;
            int slot;
            Inventory inventory;
            Player player;
            block45: {
                block43: {
                    player = (Player)e.getWhoClicked();
                    if (e.getInventory().getHolder() instanceof ShopInventory) {
                        if (!(e.getInventory().getHolder() instanceof SellGUI)) {
                            e.setCancelled(true);
                        }
                    } else {
                        return;
                    }
                    if (e.getClick() == ClickType.DOUBLE_CLICK) {
                        return;
                    }
                    if (e.getClickedInventory() == null || e.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
                        return;
                    }
                    if (e.getCurrentItem() == null || e.getCurrentItem().getType() == XMaterial.AIR.parseMaterial()) {
                        return;
                    }
                    inventory = e.getInventory();
                    slot = e.getSlot();
                    holder = inventory.getHolder();
                    if (!(holder instanceof ShopPage)) break block43;
                    ShopPage page = (ShopPage)holder;
                    if (this.plugin.navBar.isEnabled(page.getSection()) && slot >= inventory.getSize() - 9 && slot <= inventory.getSize() - 1) {
                        this.plugin.navBar.execute(player, page, slot, page.getPage(), page.isDisabledBackButton());
                    } else {
                        ShopItem shopItem = this.plugin.getSection(page.getSection()).getShopItem(page.getSection() + "." + page.getItem(slot));
                        if (shopItem == null) {
                            return;
                        }
                        if (shopItem.isLinked()) {
                            this.plugin.getSection(shopItem.getSubSection()).openShopSection(player, page.isDisabledBackButton(), shopItem.section);
                            return;
                        }
                        if (!shopItem.hasItemError()) {
                            if (shopItem.isDisplayItem() || !this.isAllowedGamemode(player)) {
                                return;
                            }
                            if (e.getClick().isLeftClick()) {
                                if (shopItem.getBuyPrice() >= 0.0) {
                                    if (shopItem.isMaxBuy(0)) {
                                        this.purchaseItem(player, shopItem);
                                        inventory.setItem(e.getSlot(), this.plugin.getSection(shopItem.section).updateItem(player, shopItem));
                                    } else {
                                        new TransactionMenu(player, shopItem, page.isDisabledBackButton(), Transaction.Mode.BUY, Transaction.Type.BUY_SCREEN, 1).open();
                                    }
                                }
                            } else if (e.getClick().equals((Object)ClickType.SHIFT_RIGHT)) {
                                if (shopItem.getSellPrice() < 0.0 || !this.plugin.MMB) {
                                    return;
                                }
                                this.sellItem(player, shopItem, Integer.MAX_VALUE);
                            } else if (e.getClick().isRightClick() && shopItem.getSellPrice() >= 0.0) {
                                if (shopItem.isMaxSell(0)) {
                                    this.sellItem(player, shopItem, shopItem.getStackSize());
                                    inventory.setItem(e.getSlot(), this.plugin.getSection(shopItem.section).updateItem(player, shopItem));
                                } else {
                                    new TransactionMenu(player, shopItem, page.isDisabledBackButton(), Transaction.Mode.SELL, Transaction.Type.SELL_SCREEN, 1).open();
                                }
                            }
                        } else {
                            SendMessage.chatToPlayer(player, Lang.ITEM_ERROR.get());
                        }
                    }
                    break block44;
                }
                if (!(holder instanceof TransactionMenu)) break block45;
                TransactionMenu menu = (TransactionMenu)holder;
                if (this.plugin.navBar.isEnableTransactionNav() && slot >= inventory.getSize() - 9 && slot <= inventory.getSize() - 1) {
                    this.plugin.navBar.execute(player, menu.getShopItem(), slot - (inventory.getSize() - 9), menu.isDisabledBackButton(), menu.getTransactionMode(), menu.getTransactionType(), menu.getAmount());
                }
                CreateItem.TransactionItemAction action = TransactionMenus.getActionFromSlot(menu.getTransactionType(), slot);
                switch (action) {
                    case NONE: {
                        break;
                    }
                    case BACK: {
                        if (menu.getTransactionType() != Transaction.Type.BUY_STACKS_SCREEN) {
                            ShopSection section = this.plugin.getSection(menu.getShopItem().section);
                            section.openShopSection(player, section.getPageForShopItem(menu.getShopItem().itemLoc), menu.isDisabledBackButton());
                            break;
                        }
                        new TransactionMenu(player, menu.getShopItem(), menu.isDisabledBackButton(), menu.getTransactionMode(), Transaction.Type.BUY_SCREEN, menu.getAmount()).open();
                        break;
                    }
                    case INSTA_BUY: 
                    case INSTA_SELL: {
                        menu.setAmount(TransactionMenus.getItemFromSlot(menu.getTransactionType(), slot).getItem().getAmount());
                    }
                    case CONFIRM_TRANSACTION: {
                        this.completeTransaction(menu, player);
                        break;
                    }
                    case OPEN_BUY_STACKS: {
                        if (!menu.getShopItem().isMaxBuy(menu.getSelectedItem().getMaxStackSize())) {
                            new TransactionMenu(player, menu.getShopItem(), menu.isDisabledBackButton(), Transaction.Mode.BUY, Transaction.Type.BUY_STACKS_SCREEN, menu.getAmount()).open();
                            break;
                        }
                        break block44;
                    }
                    case SELL_ALL: {
                        this.completeSellAll(menu, player);
                        break;
                    }
                    default: {
                        menu.updateAmount(action);
                        break;
                    }
                }
                break block44;
            }
            if (holder instanceof MainMenu) {
                if (this.plugin.navBar.isEnableMainNav() && slot >= inventory.getSize() - 9 && slot <= inventory.getSize() - 1) {
                    this.plugin.navBar.execute(player, slot - (inventory.getSize() - 9));
                } else {
                    String section = this.plugin.getMainMenuSectionForSlot(slot);
                    if (section != null && this.plugin.getSections().containsKey(section)) {
                        if (PermissionsCache.hasPermission(player, "EconomyShopGUI.shop." + section.toLowerCase())) {
                            this.plugin.getSection(section).openShopSection(player, false);
                        } else {
                            SendMessage.chatToPlayer(player, Lang.NO_PERMISSIONS_TO_OPEN_SHOP.get());
                        }
                    }
                }
            } else if (holder instanceof SellGUI && this.plugin.navBar.isEnableSellGUINav() && slot >= inventory.getSize() - 9 && slot <= inventory.getSize() - 1) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onMenuClose(InventoryCloseEvent e) {
        if (e.getInventory().getHolder() instanceof ShopInventory) {
            Player player = (Player)e.getPlayer();
            if (e.getInventory().getHolder() instanceof SellGUI) {
                SellGUI gui = (SellGUI)e.getInventory().getHolder();
                gui.sellItems(player);
            }
            this.plugin.scheduleSyncDelayedTask(() -> ((Player)player).updateInventory(), 1L);
        }
    }

    private boolean isAllowedGamemode(Player player) {
        if (this.plugin.bannedGamemodes.contains(player.getGameMode()) && !PermissionsCache.hasPermission(player, "EconomyShopGUI.bypassgamemode")) {
            SendMessage.chatToPlayer(player, Lang.CANNOT_ENTER_SHOP_BANNED_GAMEMODE.get().replace("%gamemode%", player.getGameMode().name().toLowerCase()));
            return false;
        }
        return true;
    }

    private void completeTransaction(TransactionMenu menu, Player player) {
        Transaction.Result result = Transaction.Result.SUCCESS;
        double price = 0.0;
        int amount = 0;
        if (menu.getTransactionMode() != Transaction.Mode.SELL) {
            if (menu.getBasePrice() >= 0.0) {
                int freeSpace = menu.getFreeSpace();
                if (freeSpace != 0) {
                    amount = menu.getAmountToSell(freeSpace);
                    PreTransactionEvent preTransactionEvent = new PreTransactionEvent(menu.getShopItem(), player, amount, menu.getPrice(amount), menu.getTransactionType());
                    Bukkit.getPluginManager().callEvent((Event)preTransactionEvent);
                    price = preTransactionEvent.getPrice();
                    if (!preTransactionEvent.isCancelled()) {
                        if (this.plugin.getEcoHandler().getEcon(menu.getShopItem().getEcoType()).getBalance((OfflinePlayer)player) >= price) {
                            this.plugin.getEcoHandler().getEcon(menu.getShopItem().getEcoType()).withdrawBalance((OfflinePlayer)player, price);
                            menu.sendTransactionCompleteMessage(price);
                            menu.addItemStacks();
                            if (menu.getShopItem().isCloseMenu()) {
                                player.closeInventory();
                                return;
                            }
                            menu.open();
                        } else {
                            SendMessage.chatToPlayer(player, Lang.INSUFFICIENT_MONEY.get().replace("%currency%", this.plugin.getEcoHandler().getEcon(menu.getShopItem().getEcoType()).getFriendly()));
                            result = Transaction.Result.INSUFFICIENT_FUNDS;
                        }
                    } else {
                        result = Transaction.Result.TRANSACTION_CANCELLED;
                    }
                } else {
                    SendMessage.chatToPlayer(player, Lang.MORE_SPACE_NEEDED.get());
                    result = Transaction.Result.NO_INVENTORY_SPACE;
                }
            } else {
                SendMessage.chatToPlayer(player, Lang.CANNOT_PURCHASE_ITEM.get());
                result = Transaction.Result.NEGATIVE_ITEM_PRICE;
            }
        } else {
            Double sellPrice = menu.sellAllItems(menu.getAmount());
            if (sellPrice != null) {
                amount = menu.getTotalAmount();
                PreTransactionEvent preTransactionEvent = new PreTransactionEvent(menu.getShopItem(), player, amount, sellPrice, menu.getTransactionType());
                Bukkit.getPluginManager().callEvent((Event)preTransactionEvent);
                price = preTransactionEvent.getPrice();
                if (!preTransactionEvent.isCancelled()) {
                    if (sellPrice >= 0.0) {
                        this.plugin.getEcoHandler().getEcon(menu.getShopItem().getEcoType()).depositBalance((OfflinePlayer)player, sellPrice);
                        menu.sendTransactionCompleteMessage(sellPrice);
                        menu.emptyCache();
                        if (menu.getShopItem().isCloseMenu()) {
                            player.closeInventory();
                            return;
                        }
                        menu.open();
                    } else {
                        SendMessage.chatToPlayer(player, Lang.ITEM_CANNOT_BE_SOLD.get());
                        result = Transaction.Result.NEGATIVE_ITEM_PRICE;
                    }
                } else {
                    result = Transaction.Result.TRANSACTION_CANCELLED;
                }
            } else {
                SendMessage.chatToPlayer(player, Lang.NO_ITEM_FOUND.get());
                result = Transaction.Result.NO_ITEMS_FOUND;
            }
        }
        Bukkit.getPluginManager().callEvent((Event)new PostTransactionEvent(menu.getShopItem(), player, amount, price, menu.getTransactionType(), result));
    }

    private void completeSellAll(TransactionMenu menu, Player player) {
        Transaction.Result result = Transaction.Result.SUCCESS;
        Double sellPrice = menu.sellAllItems(Integer.MAX_VALUE);
        if (sellPrice != null) {
            PreTransactionEvent preTransactionEvent = new PreTransactionEvent(menu.getShopItem(), player, menu.getAmount(), sellPrice, menu.getTransactionType());
            Bukkit.getPluginManager().callEvent((Event)preTransactionEvent);
            sellPrice = preTransactionEvent.getPrice();
            if (!preTransactionEvent.isCancelled()) {
                if (sellPrice >= 0.0) {
                    this.plugin.getEcoHandler().getEcon(menu.getShopItem().getEcoType()).depositBalance((OfflinePlayer)player, sellPrice);
                    menu.sendTransactionCompleteMessage(sellPrice);
                    menu.emptyCache();
                    if (menu.getShopItem().isCloseMenu()) {
                        player.closeInventory();
                        return;
                    }
                    menu.open();
                } else {
                    result = Transaction.Result.NEGATIVE_ITEM_PRICE;
                }
            } else {
                result = Transaction.Result.TRANSACTION_CANCELLED;
            }
        } else {
            SendMessage.chatToPlayer(player, Lang.NO_ITEM_TO_BE_SOLD.get());
            result = Transaction.Result.NO_ITEMS_FOUND;
            sellPrice = 0.0;
        }
        Bukkit.getPluginManager().callEvent((Event)new PostTransactionEvent(menu.getShopItem(), player, menu.getAmount(), sellPrice, menu.getTransactionType(), result));
    }

    private void purchaseItem(Player p, ShopItem shopItem) {
        int amount = shopItem.getStackSize();
        double price = 0.0;
        if (!this.canBuy(p, shopItem)) {
            SendMessage.chatToPlayer(p, Lang.MORE_SPACE_NEEDED.get());
            this.callPost(shopItem, p, amount, price, Transaction.Type.QUICK_BUY, Transaction.Result.NO_INVENTORY_SPACE);
            return;
        }
        amount = this.getFinalAmount(shopItem, p);
        PreTransactionEvent preTransactionEvent = new PreTransactionEvent(Collections.singletonMap(shopItem, amount), Collections.singletonMap(shopItem.getEcoType(), shopItem.getBuyPrice(p) * (double)amount), p, amount, Transaction.Type.QUICK_BUY);
        Bukkit.getPluginManager().callEvent((Event)preTransactionEvent);
        price = preTransactionEvent.getPrice();
        if (preTransactionEvent.isCancelled()) {
            this.callPost(shopItem, p, amount, price, Transaction.Type.QUICK_BUY, Transaction.Result.TRANSACTION_CANCELLED);
            return;
        }
        if (this.plugin.getEcoHandler().getEcon(shopItem.getEcoType()).getBalance((OfflinePlayer)p) < price) {
            SendMessage.chatToPlayer(p, Lang.INSUFFICIENT_MONEY.get());
            this.callPost(shopItem, p, amount, price, Transaction.Type.QUICK_BUY, Transaction.Result.INSUFFICIENT_FUNDS);
            return;
        }
        this.plugin.getEcoHandler().getEcon(shopItem.getEcoType()).withdrawBalance((OfflinePlayer)p, price);
        ItemStack stack = new ItemStack(shopItem.getItemToGive());
        stack.setAmount(amount);
        p.getInventory().addItem(new ItemStack[]{stack});
        SendMessage.sendTransactionMessage(p, amount, price, shopItem, Transaction.Mode.BUY, Transaction.Type.QUICK_BUY);
        if (shopItem.isCloseMenu()) {
            p.closeInventory();
            return;
        }
        this.callPost(shopItem, p, amount, price, Transaction.Type.QUICK_BUY, Transaction.Result.SUCCESS);
    }

    private void sellItem(Player p, ShopItem shopItem, int amount) {
        double price = 0.0;
        if (!this.canSell(p, shopItem)) {
            SendMessage.chatToPlayer(p, Lang.NO_ITEM_FOUND.get());
            this.callPost(shopItem, p, amount, price, Transaction.Type.QUICK_SELL, Transaction.Result.NO_ITEMS_FOUND);
            return;
        }
        ArrayList<ItemStack> items = this.getSellAble(p, shopItem, amount);
        amount = items.stream().mapToInt(ItemStack::getAmount).sum();
        price = items.stream().mapToDouble(i -> shopItem.getSellPrice(p, (ItemStack)i)).sum();
        PreTransactionEvent preTransactionEvent = new PreTransactionEvent(shopItem, p, amount, price, Transaction.Type.QUICK_SELL);
        Bukkit.getPluginManager().callEvent((Event)preTransactionEvent);
        price = preTransactionEvent.getPrice();
        if (preTransactionEvent.isCancelled()) {
            this.callPost(shopItem, p, amount, price, Transaction.Type.QUICK_SELL, Transaction.Result.TRANSACTION_CANCELLED);
            return;
        }
        this.plugin.getEcoHandler().getEcon(shopItem.getEcoType()).depositBalance((OfflinePlayer)p, price);
        items.forEach(item -> p.getInventory().removeItem(new ItemStack[]{item}));
        SendMessage.sendTransactionMessage(p, amount, price, shopItem, Transaction.Mode.SELL, Transaction.Type.QUICK_SELL);
        if (shopItem.isCloseMenu()) {
            p.closeInventory();
            return;
        }
        this.callPost(shopItem, p, amount, price, Transaction.Type.QUICK_SELL, Transaction.Result.SUCCESS);
    }

    private void callPost(ShopItem shopItem, Player p, int amount, double price, Transaction.Type type, Transaction.Result result) {
        Bukkit.getPluginManager().callEvent((Event)new PostTransactionEvent(shopItem, p, amount, price, type, result));
    }

    private ArrayList<ItemStack> getSellAble(Player p, ShopItem shopItem, int limit) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < 36; ++i) {
            ItemStack itemInInv = p.getInventory().getItem(i);
            if (itemInInv == null || itemInInv.getType().equals((Object)Material.AIR) || !shopItem.match(itemInInv)) continue;
            if (limit < itemInInv.getAmount()) {
                ItemStack item = new ItemStack(itemInInv);
                item.setAmount(limit);
                items.add(item);
                break;
            }
            items.add(itemInInv);
            limit -= itemInInv.getAmount();
        }
        return items;
    }

    private boolean canSell(Player p, ShopItem shopItem) {
        for (int i = 0; i < 36; ++i) {
            ItemStack itemInInv = p.getInventory().getItem(i);
            if (itemInInv == null || itemInInv.getType().equals((Object)Material.AIR) || !shopItem.match(itemInInv)) continue;
            return true;
        }
        return false;
    }

    private boolean canBuy(Player p, ShopItem shopItem) {
        return p.getInventory().firstEmpty() != -1 || Arrays.stream(p.getInventory().getContents()).anyMatch(stack -> stack != null && stack.isSimilar(shopItem.getItemToGive()) && stack.getAmount() < stack.getMaxStackSize());
    }

    private int getFinalAmount(ShopItem shopItem, Player p) {
        int freeSpace = 0;
        int maxStackSize = shopItem.getItemToGive().getMaxStackSize();
        List<ItemStack> items = Arrays.asList(p.getInventory().getContents());
        for (int i = 0; i < 36; ++i) {
            ItemStack item = items.get(i);
            if (item == null || item.getType().equals((Object)Material.AIR)) {
                freeSpace += maxStackSize;
                continue;
            }
            if (!item.isSimilar(shopItem.getItemToGive()) || item.getAmount() >= maxStackSize) continue;
            freeSpace += maxStackSize - item.getAmount();
        }
        return shopItem.getStackSize() > freeSpace && !this.plugin.dropItemsOnGround ? freeSpace : shopItem.getStackSize();
    }
}

