/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.files;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.methodes.SendMessage;
import org.bukkit.ChatColor;

public class TransactionLog {
    private File file;
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final ArrayList<String> cache = new ArrayList();

    public boolean setup() {
        this.file = new File(EconomyShopGUI.getInstance().getDataFolder(), "transaction-log.txt");
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                SendMessage.errorMessage("Failed to create the transactions log file");
                return false;
            }
        }
        return true;
    }

    public void log(String transaction) {
        this.cache.add("[" + this.dateFormatter.format(new Date().getTime()) + "] - " + ChatColor.stripColor((String)transaction));
    }

    public void save() {
        if (!this.cache.isEmpty()) {
            try {
                Files.write(this.file.toPath(), this.cache, StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                SendMessage.errorMessage("Failed to create the transactions log file");
            }
        }
    }
}

