/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.methodes;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.CalculateAmount;
import me.gypopo.economyshopgui.methodes.CreateItemMethodes;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.objects.TransactionItem;
import me.gypopo.economyshopgui.objects.TransactionScreen;
import me.gypopo.economyshopgui.util.FireworkUtil;
import me.gypopo.economyshopgui.util.PermissionsCache;
import me.gypopo.economyshopgui.util.PotionTypes;
import me.gypopo.economyshopgui.util.SkullUtil;
import me.gypopo.economyshopgui.util.Transaction;
import me.gypopo.economyshopgui.util.XMaterial;
import me.gypopo.economyshopgui.util.exceptions.ItemLoadException;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.KnowledgeBookMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.persistence.PersistentDataType;

public class CreateItem {
    private final EconomyShopGUI plugin;
    private final CreateItemMethodes itemMethodes;
    private Map<String, Double> buyPrices = new HashMap<String, Double>();
    private Map<String, Double> sellPrices = new HashMap<String, Double>();
    public ItemStack fillItem;

    public CreateItem(EconomyShopGUI plugin) {
        this.plugin = plugin;
        this.itemMethodes = new CreateItemMethodes();
    }

    public Double getBaseBuyPrice(String itemPath) {
        return this.buyPrices.get(itemPath);
    }

    public Double getBaseSellPrice(String itemPath) {
        return this.sellPrices.get(itemPath);
    }

    public void addNewBuyPrice(String itemPath, Double buyPrice) {
        this.buyPrices.put(itemPath, buyPrice);
    }

    public void addNewSellPrice(String itemPath, Double sellPrice) {
        this.sellPrices.put(itemPath, sellPrice);
    }

    public ItemStack loadShopSectionItem(ShopItem shopItem) throws ItemLoadException {
        ConfigurationSection config = ConfigManager.getShop(shopItem.section).contains("pages." + shopItem.itemLoc + ".display-item") ? ConfigManager.getShop(shopItem.section).getConfigurationSection("pages." + shopItem.itemLoc + ".display-item") : ConfigManager.getShop(shopItem.section).getConfigurationSection("pages." + shopItem.itemLoc);
        if (config == null || config.getKeys(false).isEmpty()) {
            throw new ItemLoadException(Lang.ITEM_NULL.get());
        }
        ItemStack item = CreateItemMethodes.createItemMaterialFromString(config.getString("material"));
        if (item.getType() == Material.AIR) {
            return item;
        }
        if (config.contains("buy")) {
            this.addNewBuyPrice(shopItem.getItemPath(), config.getDouble("buy"));
        }
        if (config.contains("sell")) {
            this.addNewSellPrice(shopItem.getItemPath(), config.getDouble("sell"));
        }
        ItemMeta itemMeta = this.itemMethodes.setDisplayname(item, config);
        itemMeta.setLore(this.getDisplayLore(config));
        item.setItemMeta(itemMeta);
        item = this.itemMethodes.setOption(shopItem, item, config, shopItem.section, true);
        return this.plugin.versionHandler.setPathToItem(item, shopItem.getItemPath());
    }

    public ItemStack loadSectionItem(String section, String path) throws ItemLoadException {
        ConfigurationSection config = ConfigManager.getSection(section).getConfigurationSection(path);
        if (config == null || config.getKeys(false).isEmpty()) {
            throw new ItemLoadException(ChatColor.stripColor((String)Lang.ITEM_NULL.get()));
        }
        ItemStack item = CreateItemMethodes.createItemMaterialFromString(config.getString("material"));
        if (item.getType() == Material.AIR) {
            throw new ItemLoadException("Item material cannot be AIR");
        }
        ItemMeta itemMeta = this.itemMethodes.setDisplayname(item, config);
        List<String> lore = new ArrayList<String>();
        lore = this.itemMethodes.setDisplayLore(lore, config, null);
        itemMeta.setLore(lore);
        itemMeta.addItemFlags(ItemFlag.values());
        item.setItemMeta(itemMeta);
        item = this.itemMethodes.setSectionItemOption(item, config);
        return item;
    }

    public ItemStack loadItemToGive(ShopItem shopItem) throws ItemLoadException {
        ConfigurationSection config = ConfigManager.getShop(shopItem.section).getConfigurationSection("pages." + shopItem.itemLoc);
        ItemStack item = CreateItemMethodes.createItemMaterialFromString(config.getString("material"));
        if (item.getType() == Material.AIR) {
            return item;
        }
        item = this.itemMethodes.setName(item, config);
        if (this.plugin.boughtItemsLore) {
            List<String> lore = new ArrayList<String>();
            lore = this.itemMethodes.setLore(lore, config, null);
            ItemMeta meta = item.getItemMeta();
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        item = this.itemMethodes.setOption(shopItem, item, config, shopItem.section, false);
        return item;
    }

    public ItemStack getInvalidShopItem(String section, String locateItem) {
        return this.createItem(XMaterial.BARRIER.parseItem(), Lang.ITEM_ERROR.get(), new String[0]);
    }

    public ItemStack getInvalidShopItem(String section, String locateItem, ItemLoadException e) {
        List<String> lore = CalculateAmount.splitLongString(e.getMessage());
        lore.replaceAll(s -> this.plugin.formatColors("&c" + s));
        ItemStack item = new ItemStack(Material.BARRIER);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(lore.remove(0));
        if (!lore.isEmpty()) {
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack getTransactionItem(String path, String displayname) {
        try {
            ItemStack item = CreateItemMethodes.createItemMaterialFromString(ConfigManager.getConfig().getString(path + ".material"));
            if (item.getType() == Material.AIR) {
                throw new ItemLoadException("Item material cannot be air");
            }
            return displayname == null ? item : this.createItem(item, 1, displayname);
        }
        catch (ItemLoadException e) {
            SendMessage.logDebugMessage(e.getMessage());
            SendMessage.errorItemConfig(path);
            ItemStack item = XMaterial.matchXMaterial(ConfigManager.getConfig().getDef().getString(path + ".material")).get().parseItem();
            return displayname == null ? item : this.createItem(item, 1, displayname);
        }
    }

    public List<ItemStack> getAllowedTools() {
        ArrayList<ItemStack> allowedTools = new ArrayList<ItemStack>();
        ConfigurationSection section = ConfigManager.getConfig().getConfigurationSection("spawner-break-tools");
        if (section == null) {
            return new ArrayList<ItemStack>();
        }
        for (String key : section.getKeys(false)) {
            try {
                ItemStack item = CreateItemMethodes.createItemMaterialFromString(section.getString(key + ".material"));
                allowedTools.add(this.itemMethodes.setEnchantments(item, null, section.getConfigurationSection(key)));
            }
            catch (ItemLoadException e) {
                SendMessage.logDebugMessage(e.getMessage());
                SendMessage.errorItemConfig("spawner-break-tools." + key);
            }
        }
        return allowedTools;
    }

    public boolean isShopItem(ItemStack itemToMatch, ItemStack shopItem) {
        if (!itemToMatch.getType().equals((Object)shopItem.getType())) {
            return false;
        }
        if (itemToMatch.getType().equals((Object)XMaterial.SPAWNER.parseMaterial())) {
            return this.plugin.getSpawnerManager().getProvider().isShopSpawner(itemToMatch, shopItem);
        }
        return this.plugin.isSimilar(itemToMatch, shopItem);
    }

    public double getShopItemSellPrice(ItemStack itemToSell, String itemPath) {
        double price = this.getBaseSellPrice(itemPath);
        return itemToSell.getType().equals((Object)XMaterial.SPAWNER.parseMaterial()) ? this.plugin.getSpawnerManager().getProvider().getSpawnerSellPrice(itemToSell, price) : price * (double)itemToSell.getAmount();
    }

    @Deprecated
    public ShopItem matchShopItem(Player player, ItemStack itemToLookFor) {
        if (this.plugin.shopItemsByMaterialName.containsKey(itemToLookFor.getType().name())) {
            for (ShopItem shopItem : this.plugin.shopItemsByMaterialName.get(itemToLookFor.getType().name())) {
                if (!PermissionsCache.hasPermission(player, "EconomyShopGUI.shop." + shopItem.section) || shopItem.getSellPrice() < 0.0 || shopItem.isDisplayItem() || !shopItem.match(itemToLookFor)) continue;
                return shopItem;
            }
        }
        return null;
    }

    public ShopItem matchShopItem(ItemStack itemToLookFor) {
        if (this.plugin.shopItemsByMaterialName.containsKey(itemToLookFor.getType().name())) {
            for (ShopItem shopItem : this.plugin.shopItemsByMaterialName.get(itemToLookFor.getType().name())) {
                if (shopItem.isDisplayItem() || !shopItem.match(itemToLookFor)) continue;
                return shopItem;
            }
        }
        return null;
    }

    public ShopItem matchShopItem(ItemStack itemToLookFor, Player player, String root) {
        if (this.plugin.shopItemsByMaterialName.containsKey(itemToLookFor.getType().name())) {
            for (ShopItem shopItem : this.plugin.shopItemsByMaterialName.get(itemToLookFor.getType().name())) {
                if (!PermissionsCache.hasPermission(player, "EconomyShopGUI." + root + "." + shopItem.section) || shopItem.getSellPrice() < 0.0 || shopItem.isDisplayItem() || !shopItem.match(itemToLookFor)) continue;
                return shopItem;
            }
        }
        return null;
    }

    public ItemStack createSpawner(EntityType spawnerentity) {
        ItemStack spawnertogive = this.createItem(XMaterial.SPAWNER.parseItem(), 1, this.plugin.getSpawnerName(spawnerentity));
        return spawnertogive;
    }

    public ItemStack createItem(ItemStack item, Integer amount, String Displayname) {
        item.setAmount(amount.intValue());
        ItemMeta mitemStack = item.getItemMeta();
        mitemStack.setDisplayName(Displayname);
        item.setItemMeta(mitemStack);
        return item;
    }

    public ItemStack createItem(ItemStack item, String Displayname, String ... lore) {
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Displayname);
        if (lore != null) {
            ArrayList<String> customlore = new ArrayList<String>();
            customlore.addAll(Arrays.asList(lore));
            meta.setLore(customlore);
        }
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack createFillItem(String section, ConfigurationSection config) {
        if (config == null) {
            return null;
        }
        try {
            ItemStack item = CreateItemMethodes.createItemMaterialFromString(config.getString("material"));
            if (item.getType() == Material.AIR) {
                return item;
            }
            ItemMeta meta = item.getItemMeta();
            if (config.contains("name")) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("name")));
            }
            if (config.contains("lore")) {
                meta.setLore(config.getStringList("lore").stream().map(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s)).collect(Collectors.toList()));
            }
            if (config.contains("enchantment-glint")) {
                meta.addEnchant(Enchantment.WATER_WORKER, 1, false);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            if (config.contains("skullowner")) {
                if (XMaterial.matchXMaterial(item).equals((Object)XMaterial.PLAYER_HEAD)) {
                    SkullUtil.setSkullTexture(item, (SkullMeta)meta, config.getString("skullowner"), false);
                } else {
                    throw new ItemLoadException(Lang.MATERIAL_NEEDS_TO_BE_SKULL.get());
                }
            }
            item.setItemMeta(meta);
            return item;
        }
        catch (ItemLoadException e) {
            SendMessage.warnMessage(e.getMessage());
            if (section == null) {
                SendMessage.errorItemConfig(config.getCurrentPath());
            } else {
                SendMessage.errorSections(section, config.getCurrentPath());
            }
            return null;
        }
    }

    public HashMap<String, Object> getShopItem(ItemStack item, double buyPrice, double sellPrice) {
        HashMap<String, Object> keys = new HashMap<String, Object>();
        if (this.plugin.version > 112) {
            keys.put("material", item.getType().name());
        } else if (XMaterial.matchXMaterial(item.getType().name() + ":" + item.getDurability()).isPresent()) {
            keys.put("material", item.getType().name() + ":" + item.getDurability());
        } else {
            SendMessage.warnMessage(Lang.ITEM_MATERIAL_NULL.get().replace("%material%", item.getType().name() + ":  " + item.getDurability()));
        }
        keys.put("buy", buyPrice);
        keys.put("sell", sellPrice);
        if (item.getAmount() > 1) {
            keys.put("stack-size", item.getAmount());
        }
        if (item.hasItemMeta()) {
            ArmorMeta am;
            ItemMeta meta = item.getItemMeta();
            if (meta.hasDisplayName()) {
                keys.put("name", meta.getDisplayName());
            }
            if (this.plugin.version >= 112 && meta instanceof KnowledgeBookMeta) {
                KnowledgeBookMeta bookMeta = (KnowledgeBookMeta)item.getItemMeta();
                ArrayList<String> recipes = new ArrayList<String>();
                for (int i = 0; i < bookMeta.getRecipes().size(); ++i) {
                    recipes.add(((NamespacedKey)bookMeta.getRecipes().get(i)).getKey());
                }
                keys.put("recipes", recipes);
            } else if (meta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)item.getItemMeta();
                keys.put("skullowner", skullMeta.getOwner());
            } else if (meta instanceof LeatherArmorMeta) {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)item.getItemMeta();
                org.bukkit.Color color = leatherArmorMeta.getColor();
                keys.put("armorcolor", "#" + Integer.toHexString(new Color(color.getRed(), color.getGreen(), color.getBlue()).getRGB()).substring(2).toUpperCase());
            } else if (meta instanceof FireworkMeta) {
                keys.putAll(FireworkUtil.serialize((FireworkMeta)meta));
            } else if (this.plugin.version >= 120 && meta instanceof ArmorMeta && (am = (ArmorMeta)meta).hasTrim()) {
                ArmorTrim trim = am.getTrim();
                keys.put("armor-trim.type", trim.getMaterial().getKey().getKey());
                keys.put("armor-trim.pattern", trim.getPattern().getKey().getKey());
            }
            if (!meta.getEnchants().isEmpty() || item.getType() == Material.ENCHANTED_BOOK) {
                ArrayList enchants = new ArrayList();
                (item.getType() == Material.ENCHANTED_BOOK ? ((EnchantmentStorageMeta)item.getItemMeta()).getStoredEnchants() : item.getEnchantments()).forEach((enchant, strength) -> {
                    if (strength > enchant.getMaxLevel() && !this.plugin.allowUnsafeEnchants) {
                        strength = enchant.getMaxLevel();
                    }
                    enchants.add(enchant.getName() + ":" + strength);
                });
                keys.put("enchantments", enchants);
            }
            if (PotionTypes.canHaveEffects(item.getType())) {
                ArrayList<String> potionTypes = new ArrayList<String>();
                for (PotionTypes effect : PotionTypes.getPotionTypes(item)) {
                    potionTypes.add(effect.name());
                }
                keys.put("potiontypes", potionTypes);
            }
            if (meta.hasLore()) {
                ArrayList<String> lore = new ArrayList<String>();
                for (String line : meta.getLore()) {
                    lore.add(line.replaceAll(String.valueOf('\u00a7'), "&"));
                }
                keys.put("lore", lore);
            }
        }
        if (this.plugin.version >= 116 && item.hasItemMeta()) {
            try {
                if ((Integer)item.getItemMeta().getPersistentDataContainer().get(new NamespacedKey(Bukkit.getPluginManager().getPlugin("AutoSellChests"), "autosell"), PersistentDataType.INTEGER) == 1) {
                    keys.put("autosell", true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (item.getType().equals((Object)XMaterial.SPAWNER.parseMaterial())) {
            keys.put("spawnertype", this.plugin.getSpawnerManager().getProvider().getSpawnedType(item));
        }
        return keys;
    }

    public TransactionScreen getTransactionScreen(Transaction.Type menu) {
        ArrayList<TransactionItem> items = new ArrayList<TransactionItem>();
        String section = menu.name().toLowerCase().replace("_", "-");
        int size = CalculateAmount.getInvSlots(ConfigManager.getConfig().getInt(section + ".menu-size", 5));
        for (String s : ConfigManager.getConfig().getConfigurationSection(section + ".items").getKeys(false)) {
            TransactionItemAction action = TransactionItemAction.getFromString(ConfigManager.getConfig().getString(section + ".items." + s + ".action", "NONE"));
            TransactionItemType type = TransactionItemType.getFromString(action, ConfigManager.getConfig().getString(section + ".items." + s + ".type", "NORMAL"));
            if (type != TransactionItemType.NORMAL && type != TransactionItemType.DECREASE_AMOUNT && type != TransactionItemType.INCREASE_AMOUNT && items.stream().filter(i -> i.getType() == type).findFirst().orElse(null) != null) {
                SendMessage.warnMessage("The " + section + " cannot contain multiple items from type " + type.name() + ", instead use the ability to copy this item into multiple slots by using 'slot: 9,13,14,15', skipping...");
                SendMessage.errorItemConfig(section + ".items." + s);
                continue;
            }
            ItemStack item = new ItemStack(Material.AIR);
            if (type != TransactionItemType.SELECTED_ITEM && (item = this.getTransactionItem(section + ".items." + s)) == null) continue;
            List<Integer> slots = this.getSlots(ConfigManager.getConfig().getString(section + ".items." + s + ".slot", ConfigManager.getConfig().getDef().getString(section + ".items." + s + ".slot", null)));
            if (slots == null) {
                SendMessage.warnMessage("Invalid slot for item, skipping...");
                SendMessage.errorItemConfig(section + ".items." + s);
                continue;
            }
            for (int i2 = slots.size() - 1; i2 > 0; --i2) {
                int slot = slots.get(i2);
                if (slot < (this.plugin.navBar.isEnableTransactionNav() ? size - 9 : size) && slot >= 0) continue;
                SendMessage.warnMessage("Item slot " + slot + " is out of bounds for menu size of " + size + ", skipping ...");
                SendMessage.errorItemConfig(section + ".items." + s);
                slots.remove(slot);
            }
            items.add(new TransactionItem(action, type, item, slots));
        }
        if (!items.stream().anyMatch(i -> i.getAction() == TransactionItemAction.INSTA_BUY || i.getAction() == TransactionItemAction.INSTA_SELL)) {
            if (!items.stream().anyMatch(i -> i.getType() == TransactionItemType.SELECTED_ITEM)) {
                SendMessage.warnMessage("The transaction screen inside the config.yml at path '" + section + "' needs to contain atleast one item with type SELECTED_ITEM, adding default...");
                items.add(22, new TransactionItem(TransactionItemAction.NONE, TransactionItemType.SELECTED_ITEM, new ItemStack(Material.AIR), Collections.singletonList(22)));
            }
            if (!items.stream().anyMatch(i -> i.getType() == TransactionItemType.CONFIRM)) {
                SendMessage.warnMessage("The transaction screen inside the config.yml at path '" + section + "' needs to contain atleast one item with type CONFIRM, adding default...");
                items.add(13, new TransactionItem(TransactionItemAction.CONFIRM_TRANSACTION, TransactionItemType.CONFIRM, this.getTransactionItem(section + ".items.7"), Collections.singletonList(13)));
            }
        }
        return new TransactionScreen(items, size);
    }

    private List<Integer> getSlots(String slots) {
        if (slots == null) {
            return null;
        }
        try {
            return new ArrayList<Integer>(Collections.singletonList(Integer.parseInt(slots)));
        }
        catch (NumberFormatException e) {
            ArrayList<Integer> pos = new ArrayList<Integer>();
            slots = StringUtils.deleteWhitespace((String)slots);
            for (String index : slots.split(",")) {
                String[] params = index.split("-");
                if (params.length == 2) {
                    for (int i = Integer.parseInt(params[0]); i < Integer.parseInt(params[1]); ++i) {
                        pos.add(i);
                    }
                    continue;
                }
                if (params.length != 1) continue;
                pos.add(Integer.parseInt(params[0]));
            }
            if (!pos.isEmpty()) {
                return pos;
            }
            return null;
        }
    }

    private ItemStack getTransactionItem(String path) {
        try {
            ItemStack item = CreateItemMethodes.createItemMaterialFromString(ConfigManager.getConfig().getString(path + ".material"));
            if (item.getType() == Material.AIR) {
                return null;
            }
            int amount = ConfigManager.getConfig().getInt(path + ".stack-size", 1);
            if (amount >= 1) {
                item.setAmount(amount);
            }
            ItemMeta meta = item.getItemMeta();
            if (ConfigManager.getConfig().contains(path + ".name")) {
                meta.setDisplayName(this.getTransactionItemName(ConfigManager.getConfig().getString(path + ".name")));
            }
            if (ConfigManager.getConfig().contains(path + ".lore")) {
                meta.setLore(this.getTransactionItemLore(ConfigManager.getConfig().getStringList(path + ".lore")));
            }
            if (ConfigManager.getConfig().contains(path + ".skullowner")) {
                if (XMaterial.matchXMaterial(item).equals((Object)XMaterial.PLAYER_HEAD)) {
                    ((SkullMeta)meta).setOwner(ConfigManager.getConfig().getString(path + ".skullowner"));
                } else {
                    throw new ItemLoadException(Lang.MATERIAL_NEEDS_TO_BE_SKULL.get());
                }
            }
            item.setItemMeta(meta);
            return item;
        }
        catch (ItemLoadException e) {
            SendMessage.warnMessage(e.getMessage());
            SendMessage.errorItemConfig(path);
            if (!ConfigManager.getConfig().getDef().contains(path)) {
                return null;
            }
            ItemStack item = XMaterial.matchXMaterial(ConfigManager.getConfig().getDef().getString(path + ".material")).get().parseItem();
            item.setAmount(ConfigManager.getConfig().getDef().getInt(path + ".stack-size", 1));
            ItemMeta meta = item.getItemMeta();
            if (ConfigManager.getConfig().getDef().contains(path + ".name")) {
                meta.setDisplayName(this.getTransactionItemName(ConfigManager.getConfig().getDef().getString(path + ".name")));
            }
            if (ConfigManager.getConfig().getDef().contains(path + ".lore")) {
                meta.setLore(this.getTransactionItemLore(ConfigManager.getConfig().getDef().getStringList(path + ".lore")));
            }
            item.setItemMeta(meta);
            return item;
        }
    }

    private String getTransactionItemName(String s) {
        if (s == null) {
            return "";
        }
        if (s.contains("%translations-")) {
            try {
                Lang placeholder = Lang.valueOf(s.split("%translations-")[1].split("%")[0].toUpperCase(Locale.ENGLISH).replace("-", "_"));
                s = s.replace("%translations-" + placeholder.getKey() + "%", placeholder.get());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.plugin.formatColors(s);
    }

    private List<String> getTransactionItemLore(List<String> lore) {
        if (lore.isEmpty()) {
            return new ArrayList<String>();
        }
        return lore.stream().map(s -> {
            if (s.contains("%translations-")) {
                try {
                    Lang placeholder = Lang.valueOf(s.split("%translations-")[1].split("%")[0].toUpperCase(Locale.ENGLISH).replace("-", "_"));
                    s = s.replace("%translations-" + placeholder.getKey() + "%", placeholder.get());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return this.plugin.formatColors((String)s);
        }).collect(Collectors.toList());
    }

    public List<String> getDisplayLore(ConfigurationSection itemConfig) {
        List l = new ArrayList();
        if (itemConfig.contains("displaylore")) {
            l = itemConfig.getStringList("displaylore");
        } else if (itemConfig.contains("lore")) {
            l = itemConfig.getStringList("lore");
        }
        return l;
    }

    public static enum TransactionItemAction {
        REMOVE32,
        REMOVE16,
        REMOVE1,
        ADD1,
        ADD16,
        ADD32,
        CONFIRM_TRANSACTION,
        INSTA_BUY,
        INSTA_SELL,
        OPEN_BUY_STACKS,
        SELL_ALL,
        BACK,
        NONE;


        public static TransactionItemAction getFromString(String s) {
            try {
                return TransactionItemAction.valueOf(s.toUpperCase(Locale.ENGLISH).replace(" ", "_"));
            }
            catch (IllegalArgumentException e) {
                SendMessage.warnMessage("Failed to load action for transaction item like '" + s + "'");
                return NONE;
            }
        }
    }

    public static enum TransactionItemType {
        INCREASE_AMOUNT,
        DECREASE_AMOUNT,
        SELECTED_ITEM,
        CONFIRM,
        NORMAL;


        public static TransactionItemType getFromString(TransactionItemAction action, String s) {
            try {
                switch (action) {
                    case REMOVE32: 
                    case REMOVE16: 
                    case REMOVE1: {
                        return DECREASE_AMOUNT;
                    }
                    case ADD1: 
                    case ADD16: 
                    case ADD32: {
                        return INCREASE_AMOUNT;
                    }
                }
                return TransactionItemType.valueOf(s.toUpperCase(Locale.ENGLISH).replace(" ", "_"));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                SendMessage.warnMessage("Failed to load item type for transaction item like '" + s + "'");
                return NORMAL;
            }
        }
    }
}

