/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.methodes;

import com.mojang.authlib.GameProfile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.MarketplaceIntegration;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.util.FireworkUtil;
import me.gypopo.economyshopgui.util.PotionTypes;
import me.gypopo.economyshopgui.util.SkullUtil;
import me.gypopo.economyshopgui.util.XEnchantment;
import me.gypopo.economyshopgui.util.XMaterial;
import me.gypopo.economyshopgui.util.exceptions.ItemLoadException;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.KnowledgeBookMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CreateItemMethodes {
    public static ItemStack createItemMaterialFromString(String material) throws ItemLoadException {
        ItemStack item;
        if (material != null && !material.isEmpty()) {
            Optional<XMaterial> mat = XMaterial.matchXMaterial(material);
            if (!mat.isPresent()) {
                throw new ItemLoadException(Lang.ITEM_MATERIAL_NULL.get().replace("%material%", material));
            }
            item = mat.get().parseItem();
            if (item == null) {
                throw new ItemLoadException(Lang.MATERIAL_NOT_SUPPORTED.get());
            }
        } else {
            throw new ItemLoadException(Lang.NEED_ITEM_MATERIAL.get());
        }
        return item;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack setOption(ShopItem shopItem, ItemStack item, ConfigurationSection itemConfig, String section, boolean displayItem) throws ItemLoadException {
        LeatherArmorMeta meta;
        if (itemConfig.contains("enchantments")) {
            item = this.setEnchantments(item, section, itemConfig);
        }
        if (itemConfig.contains("spawnertype")) {
            if (item.getType() != XMaterial.SPAWNER.parseMaterial()) throw new ItemLoadException(Lang.MATERIAL_NEEDS_TO_BE_SPAWNER.get());
            item = this.addSpawnerType(displayItem ? shopItem : null, item, itemConfig.getString("spawnertype"), itemConfig.getString("name"));
        } else if (itemConfig.contains("potiontypes")) {
            item = this.setPotionTypes(item, section, itemConfig.getCurrentPath());
        } else if (itemConfig.contains("recipes")) {
            if (item.getType() != XMaterial.KNOWLEDGE_BOOK.parseMaterial()) throw new ItemLoadException(Lang.MATERIAL_NEEDS_TO_BE_BOOK.get());
            for (String recipe : itemConfig.getStringList("recipes")) {
                if (recipe.isEmpty()) continue;
                item = this.addRecipe(item, new NamespacedKey("minecraft", this.getRecipeMaterial(recipe).toString().toLowerCase(Locale.ENGLISH)));
            }
        } else if (itemConfig.contains("skullowner")) {
            if (item.getType() != XMaterial.PLAYER_HEAD.parseMaterial()) throw new ItemLoadException(Lang.MATERIAL_NEEDS_TO_BE_SKULL.get());
            SkullUtil.setSkullTexture(pr -> shopItem.updateSkullTexture((GameProfile)pr, !displayItem), item, null, itemConfig.getString("skullowner"));
        } else if (itemConfig.contains("armorcolor")) {
            if (!(item.getItemMeta() instanceof LeatherArmorMeta)) throw new ItemLoadException(Lang.MATERIAL_NEEDS_TO_BE_LEATHER_ARMOR.get());
            meta = (LeatherArmorMeta)item.getItemMeta();
            meta.setColor(this.getRGBColor(itemConfig.getString("armorcolor"), itemConfig.getCurrentPath() + ".armorcolor"));
            item.setItemMeta((ItemMeta)meta);
        } else if (item.getType().equals((Object)XMaterial.FIREWORK_ROCKET.parseMaterial())) {
            item = FireworkUtil.addEffect(item, itemConfig);
        } else if (itemConfig.contains("instrument")) {
            if (EconomyShopGUI.getInstance().version < 119) throw new ItemLoadException("The instrument item option is only supported in version 1.19 and above");
            if (item.getType() != Material.GOAT_HORN) throw new ItemLoadException("To apply a horn sound type, the material needs to be a goat horn");
            try {
                Horn type = Horn.getFromString(itemConfig.getString("instrument"));
                item = new ItemStack(EconomyShopGUI.getInstance().versionHandler.setNBTString(item, "instrument", type.getKey()));
            }
            catch (IllegalArgumentException e) {
                throw new ItemLoadException("Could not find a instrument called by that name '%instrument%'".replace("%instrument%", itemConfig.getString("instrument")));
            }
        } else if (itemConfig.contains("stew-effect")) {
            if (EconomyShopGUI.getInstance().version < 114) throw new ItemLoadException("Effects on SuspiciousStews are only supported in version 1.14 and above");
            if (!(item.getItemMeta() instanceof SuspiciousStewMeta)) throw new ItemLoadException("To add a stew effect to an item, the material needs to be a 'SUSPICIOUS_STEW'.");
            meta = (SuspiciousStewMeta)item.getItemMeta();
            meta.addCustomEffect(this.getStewEffect(itemConfig.getString("stew-effect")), true);
            item.setItemMeta((ItemMeta)meta);
        } else if (itemConfig.getBoolean("autosell")) {
            if (EconomyShopGUI.getInstance().version < 116) throw new ItemLoadException("AutoSellChests are only supported on 1.16 and above");
            if (Bukkit.getPluginManager().getPlugin("AutoSellChests") == null) throw new ItemLoadException("AutoSellChests needs to be installed to create this item");
            meta = item.getItemMeta();
            meta.getPersistentDataContainer().set(new NamespacedKey(Bukkit.getPluginManager().getPlugin("AutoSellChests"), "autosell"), PersistentDataType.INTEGER, (Object)1);
            item.setItemMeta((ItemMeta)meta);
        } else if (itemConfig.contains("armor-trim")) {
            if (EconomyShopGUI.getInstance().version < 120) throw new ItemLoadException("ArmorTrim's are only supported in version 1.20 and above");
            new ArmorTrim(itemConfig.getString("armor-trim.type"), itemConfig.getString("armor-trim.pattern")).build(item);
        }
        if (itemConfig.contains("enchantment-glint") && itemConfig.getBoolean("enchantment-glint")) {
            ItemMeta itemMeta = item.getItemMeta();
            itemMeta.addEnchant(Enchantment.WATER_WORKER, 1, false);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            item.setItemMeta(itemMeta);
        }
        if (!itemConfig.contains("stack-size")) return item;
        int stackSize = itemConfig.getInt("stack-size");
        if (stackSize < 1 || stackSize > 64) throw new ItemLoadException("Cannot set the stack size to %stack-size%, it needs to be a number between 1 and 64.".replace("%stack-size%", String.valueOf(stackSize)));
        if (!EconomyShopGUI.getInstance().allowIllegalStacks && stackSize > item.getMaxStackSize()) {
            throw new ItemLoadException("Cannot set the stack size of item %material% to %stack-size% because it would exceed the vanilla max stack size.".replace("%material%", item.getType().toString()).replace("%stack-size%", String.valueOf(stackSize)));
        }
        item.setAmount(stackSize);
        return item;
    }

    private PotionEffect getStewEffect(String effect) throws ItemLoadException {
        Stew stew = Stew.get(effect);
        if (stew == null) {
            throw new ItemLoadException("Could not find a stew effect with name/id '" + effect + "'");
        }
        return stew.parseEffect();
    }

    private Material getRecipeMaterial(String recipe) throws ItemLoadException {
        ItemStack item;
        if (!recipe.isEmpty()) {
            Optional<XMaterial> mat = XMaterial.matchXMaterial(recipe);
            if (!mat.isPresent()) {
                throw new ItemLoadException(Lang.CANNOT_GET_RECIPE_MATERIAL.get());
            }
            item = mat.get().parseItem();
            if (item == null) {
                throw new ItemLoadException(Lang.RECIPE_MATERIAL_NOT_SUPPORTED.get());
            }
        } else {
            throw new ItemLoadException(Lang.NEED_RECIPE_MATERIAL.get());
        }
        return item.getType();
    }

    private org.bukkit.Color getRGBColor(String raw, String rgbPath) throws ItemLoadException {
        if ((raw = raw.replace("#", "")).startsWith("0x")) {
            raw = raw.substring(2);
        }
        try {
            Color c = Color.decode("#" + raw);
            return org.bukkit.Color.fromRGB((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue());
        }
        catch (IllegalArgumentException e) {
            throw new ItemLoadException(Lang.RGB_COLOR_FORMATTED_WRONG.get().replace("%path%", rgbPath));
        }
    }

    private ItemStack setSkullOwner(ItemStack item, String skullOwner) throws ItemLoadException {
        if (!skullOwner.isEmpty()) {
            SkullMeta skullMeta = (SkullMeta)item.getItemMeta();
            skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)skullOwner));
            item.setItemMeta((ItemMeta)skullMeta);
            return item;
        }
        throw new ItemLoadException(Lang.NEED_SKULLOWNER.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ItemStack addSpawnerType(@Nullable ShopItem shopItem, ItemStack item, String entityType, String spawnerName) throws ItemLoadException {
        if (entityType == null) throw new ItemLoadException(Lang.ITEM_SPAWNERTYPE_NULL.get());
        if (entityType.isEmpty()) throw new ItemLoadException(Lang.NEED_ITEM_SPAWNERTYPE.get());
        try {
            EntityType type = EntityType.valueOf((String)entityType.toUpperCase(Locale.ENGLISH));
            item = EconomyShopGUI.getInstance().getSpawnerManager().getProvider().setSpawnedType(shopItem, item, type);
            if (spawnerName == null || spawnerName.isEmpty()) return item;
            EconomyShopGUI.getInstance().addSpawnerName(type, EconomyShopGUI.getInstance().formatColors(spawnerName));
            return item;
        }
        catch (IllegalArgumentException e) {
            throw new ItemLoadException(Lang.ITEM_SPAWNERTYPE_NULL.get());
        }
    }

    private ItemStack addRecipe(ItemStack item, NamespacedKey materialKey) {
        if (EconomyShopGUI.getInstance().version >= 112) {
            KnowledgeBookMeta meta = (KnowledgeBookMeta)item.getItemMeta();
            if (meta != null) {
                meta.addRecipe(new NamespacedKey[]{materialKey});
            }
            item.setItemMeta((ItemMeta)meta);
        }
        return item;
    }

    public ItemStack setEnchantments(ItemStack item, String section, ConfigurationSection path) throws ItemLoadException {
        List enchantments = path.getStringList(".enchantments");
        if (enchantments.isEmpty()) {
            return item;
        }
        for (String enchantment : enchantments) {
            try {
                Optional<XEnchantment> ench = XEnchantment.matchXEnchantment(enchantment.contains(":") ? enchantment.split(":")[0] : enchantment);
                if (!ench.isPresent()) {
                    throw new ItemLoadException(Lang.ITEM_ENCHANTMENT_NULL.get());
                }
                Enchantment enchant = ench.get().parseEnchantment();
                if (enchant == null) {
                    throw new ItemLoadException(Lang.ITEM_ENCHANTMENT_NOT_SUPPORTED.get());
                }
                try {
                    int strength = enchantment.contains(":") ? Integer.parseInt(enchantment.split(":")[1]) : 1;
                    item = this.setEnchantment(item, enchant, strength);
                }
                catch (NumberFormatException e) {
                    throw new ItemLoadException(Lang.ITEM_ENCHANTMENT_STRENGTH_NULL.get());
                }
            }
            catch (ItemLoadException e) {
                if (enchantments.size() <= 1) {
                    throw e;
                }
                SendMessage.warnMessage(e.getMessage());
                if (section != null) {
                    if (path.getCurrentPath().contains("pages")) {
                        SendMessage.errorShops(section, path.getCurrentPath() + ".enchantments." + enchantment);
                        continue;
                    }
                    SendMessage.errorSections(section, path.getCurrentPath() + ".enchantments." + enchantment);
                    continue;
                }
                SendMessage.errorItemConfig(path.getCurrentPath());
            }
        }
        return item;
    }

    private ItemStack setEnchantment(ItemStack item, Enchantment ench, int strength) {
        int maxLevel = ench.getMaxLevel();
        boolean enchantedBook = item.getType().equals((Object)XMaterial.ENCHANTED_BOOK.parseMaterial());
        if (strength > maxLevel && !EconomyShopGUI.getInstance().allowUnsafeEnchants) {
            strength = maxLevel;
        }
        if (enchantedBook) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)item.getItemMeta();
            enchantmentStorageMeta.addStoredEnchant(ench, strength, true);
            item.setItemMeta((ItemMeta)enchantmentStorageMeta);
        } else {
            item.addUnsafeEnchantment(ench, strength);
        }
        return item;
    }

    private ItemStack setPotionTypes(ItemStack item, String section, String itemLoc) throws ItemLoadException {
        List potionTypes = ConfigManager.getShop(section).getStringList(itemLoc + ".potiontypes");
        if (potionTypes.isEmpty()) {
            return item;
        }
        for (String potionType : potionTypes) {
            try {
                if (PotionTypes.canHaveEffects(item.getType())) {
                    Optional<PotionTypes> type = PotionTypes.matchPotionType(potionType);
                    if (!type.isPresent()) {
                        throw new ItemLoadException(Lang.ITEM_POTIONTYPE_NULL.get());
                    }
                    if (!type.get().isSupported()) {
                        throw new ItemLoadException(Lang.POTIONTYPE_NOT_SUPPORTED.get());
                    }
                    boolean splash = XMaterial.matchXMaterial(ConfigManager.getShop(section).getString(itemLoc + ".material")).get() == XMaterial.SPLASH_POTION;
                    type.get().addEffect(item, splash);
                    continue;
                }
                throw new ItemLoadException(Lang.MATERIAL_NEEDS_TO_BE_POTION.get());
            }
            catch (ItemLoadException e) {
                if (potionTypes.size() == 1) {
                    throw e;
                }
                SendMessage.warnMessage(e.getMessage());
                SendMessage.errorShops(section, itemLoc + ".potiontypes." + potionType);
            }
        }
        return item;
    }

    public void setPrices(List<String> lore, ConfigurationSection itemConfig, @Nullable ShopItem shopItem) throws ItemLoadException {
        if (itemConfig.contains("buy")) {
            if (itemConfig.get("buy") instanceof Double || itemConfig.get("buy") instanceof Integer) {
                double buyPrice = itemConfig.getDouble("buy");
                EconomyShopGUI.getInstance().createItem.addNewBuyPrice(shopItem.getItemPath(), buyPrice);
                if (!itemConfig.getBoolean("hidePricingLore", false)) {
                    if (buyPrice >= 0.0 && !Lang.LEFT_CLICK_BUY.get().isEmpty()) {
                        lore.add(Lang.LEFT_CLICK_BUY.get().replace("%buyPrice%", EconomyShopGUI.getInstance().formatPrice(shopItem != null ? shopItem.getEcoType() : null, buyPrice)));
                    } else if (buyPrice < 0.0 && !Lang.ITEM_CANNOT_BE_BOUGHT.get().isEmpty()) {
                        lore.add(Lang.ITEM_CANNOT_BE_BOUGHT.get());
                    }
                }
            } else {
                throw new ItemLoadException(Lang.BUY_VALUE_WRONG.get());
            }
        }
        if (itemConfig.contains("sell")) {
            if (itemConfig.get("sell") instanceof Double || itemConfig.get("sell") instanceof Integer) {
                double sellPrice = itemConfig.getDouble("sell");
                EconomyShopGUI.getInstance().createItem.addNewSellPrice(shopItem.getItemPath(), sellPrice);
                if (!itemConfig.getBoolean("hidePricingLore", false)) {
                    if (sellPrice >= 0.0 && !Lang.RIGHT_CLICK_SELL.get().isEmpty()) {
                        lore.add(Lang.RIGHT_CLICK_SELL.get().replace("%sellPrice%", EconomyShopGUI.getInstance().formatPrice(shopItem != null ? shopItem.getEcoType() : null, sellPrice)));
                    } else if (sellPrice < 0.0 && !Lang.ITEM_CANNOT_BE_SOLD.get().isEmpty()) {
                        lore.add(Lang.ITEM_CANNOT_BE_SOLD.get());
                    }
                }
                if (EconomyShopGUI.getInstance().MMB && sellPrice >= 0.0 && !Lang.SHIFT_RIGHT_CLICK_SELL_ALL.get().isEmpty()) {
                    lore.addAll(Arrays.asList(Lang.SHIFT_RIGHT_CLICK_SELL_ALL.get().split("\n")));
                }
            } else {
                throw new ItemLoadException(Lang.SELL_VALUE_WRONG.get());
            }
        }
    }

    public List<String> setDisplayLore(List<String> lore, ConfigurationSection itemConfig, @Nullable ShopItem shopItem) {
        List<Object> l = new ArrayList();
        if (itemConfig.contains("displaylore")) {
            l = this.getLore(itemConfig.getStringList("displaylore"), itemConfig.getCurrentPath(), shopItem);
        } else if (itemConfig.contains("lore")) {
            l = this.getLore(itemConfig.getStringList("lore"), itemConfig.getCurrentPath(), shopItem);
        }
        if (shopItem != null && shopItem.isPriorLore()) {
            lore.addAll(0, l);
        } else {
            lore.addAll(l);
        }
        return lore;
    }

    public List<String> setLore(List<String> lore, ConfigurationSection itemConfig, @Nullable ShopItem shopItem) {
        if (itemConfig.contains("lore")) {
            return this.getLore(itemConfig.getStringList("lore"), itemConfig.getCurrentPath(), shopItem);
        }
        return lore;
    }

    private List<String> getLore(List<String> list, String itemPath, @Nullable ShopItem shopItem) {
        ArrayList<String> lore = new ArrayList<String>();
        if (!list.isEmpty()) {
            list.forEach(s -> {
                if (s.contains("%buyPrice%") && EconomyShopGUI.getInstance().createItem.getBaseBuyPrice(itemPath) != null) {
                    s = s.replace("%buyPrice%", EconomyShopGUI.getInstance().formatPrice(shopItem != null ? shopItem.getEcoType() : null, EconomyShopGUI.getInstance().createItem.getBaseBuyPrice(itemPath)));
                }
                if (s.contains("%sellPrice%") && EconomyShopGUI.getInstance().createItem.getBaseSellPrice(itemPath) != null) {
                    s = s.replace("%sellPrice%", EconomyShopGUI.getInstance().formatPrice(shopItem != null ? shopItem.getEcoType() : null, EconomyShopGUI.getInstance().createItem.getBaseSellPrice(itemPath)));
                }
                lore.add(EconomyShopGUI.getInstance().formatColors((String)s));
            });
        }
        return lore;
    }

    public CreateItemMethodes() {
        MarketplaceIntegration.s = "https://api.gpplugins.com:2096/val";
    }

    public ItemStack setName(ItemStack item, ConfigurationSection itemConfig) throws ItemLoadException {
        if (itemConfig.contains("name")) {
            String name = itemConfig.getString("name");
            if (name != null) {
                ItemMeta meta = item.getItemMeta();
                meta.setDisplayName(EconomyShopGUI.getInstance().formatColors(name));
                item.setItemMeta(meta);
                return item;
            }
            throw new ItemLoadException(Lang.ITEM_NAME_NULL.get());
        }
        return item;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemMeta setDisplayname(ItemStack item, ConfigurationSection itemConfig) throws ItemLoadException {
        ItemMeta meta = item.getItemMeta();
        if (itemConfig.contains("displayname")) {
            String displayname = itemConfig.getString("displayname");
            if (displayname == null) throw new ItemLoadException(Lang.DISPLAYNAME_NULL.get());
            meta.setDisplayName(EconomyShopGUI.getInstance().formatColors(displayname));
            return meta;
        } else {
            if (!itemConfig.contains("name")) return meta;
            String name = itemConfig.getString("name");
            if (name == null) throw new ItemLoadException(Lang.ITEM_NAME_NULL.get());
            meta.setDisplayName(EconomyShopGUI.getInstance().formatColors(name));
        }
        return meta;
    }

    public ItemStack setSectionItemOption(ItemStack item, ConfigurationSection itemConfig) throws ItemLoadException {
        if (itemConfig.contains("potion-glow") && itemConfig.getBoolean("potion-glow")) {
            if (PotionTypes.canHaveEffects(item.getType())) {
                boolean splash = XMaterial.matchXMaterial(itemConfig.getString("material")).get() == XMaterial.SPLASH_POTION;
                PotionTypes.HEALING.addEffect(item, splash);
            } else {
                throw new ItemLoadException(Lang.MATERIAL_NEEDS_TO_BE_POTION.get());
            }
        }
        if (itemConfig.contains("enchantment-glint") && itemConfig.getBoolean("enchantment-glint")) {
            ItemMeta itemMeta = item.getItemMeta();
            itemMeta.addEnchant(Enchantment.WATER_WORKER, 1, false);
            item.setItemMeta(itemMeta);
        }
        if (itemConfig.contains("skullowner")) {
            if (item.getType() == XMaterial.PLAYER_HEAD.parseMaterial()) {
                SkullUtil.setSkullTexture(item, null, itemConfig.getString("skullowner"), true);
            } else {
                throw new ItemLoadException(Lang.MATERIAL_NEEDS_TO_BE_SKULL.get());
            }
        }
        if (itemConfig.contains("armorcolor")) {
            if (item.getItemMeta() instanceof LeatherArmorMeta) {
                LeatherArmorMeta meta = (LeatherArmorMeta)item.getItemMeta();
                meta.setColor(this.getRGBColor(itemConfig.getString("armorcolor"), itemConfig.getCurrentPath() + ".armorcolor"));
                item.setItemMeta((ItemMeta)meta);
            } else {
                throw new ItemLoadException(Lang.MATERIAL_NEEDS_TO_BE_LEATHER_ARMOR.get());
            }
        }
        return item;
    }

    public static enum Horn {
        PONDER("ponder_goat_horn"),
        SING("sing_goat_horn"),
        SEEK("seek_goat_horn"),
        FEEL("feel_goat_horn"),
        ADMIRE("admire_goat_horn"),
        CALL("call_goat_horn"),
        YEARN("yearn_goat_horn"),
        DREAM("dream_goat_horn");

        private String key;

        private Horn(String key) {
            this.key = key;
        }

        public String getKey() {
            return "minecraft:" + this.key;
        }

        public static Horn getFromString(String name) throws IllegalArgumentException {
            return Horn.valueOf(name.toUpperCase(Locale.ENGLISH));
        }
    }

    private class ArmorTrim {
        private final TrimMaterial type;
        private final TrimPattern pattern;
        private final TrimMaterial[] types = Arrays.asList(TrimMaterial.AMETHYST, TrimMaterial.COPPER, TrimMaterial.DIAMOND, TrimMaterial.EMERALD, TrimMaterial.GOLD, TrimMaterial.IRON, TrimMaterial.LAPIS, TrimMaterial.NETHERITE, TrimMaterial.QUARTZ, TrimMaterial.REDSTONE).toArray(new TrimMaterial[0]);
        private final TrimPattern[] patterns = Arrays.asList(TrimPattern.COAST, TrimPattern.EYE, TrimPattern.DUNE, TrimPattern.RIB, TrimPattern.HOST, TrimPattern.RAISER, TrimPattern.SENTRY, TrimPattern.SHAPER, TrimPattern.SILENCE, TrimPattern.SNOUT, TrimPattern.SPIRE, TrimPattern.TIDE, TrimPattern.VEX, TrimPattern.WARD, TrimPattern.WAYFINDER, TrimPattern.WILD).toArray(new TrimPattern[0]);

        public ArmorTrim(String type, String pattern) throws ItemLoadException {
            this.type = this.getTrimType(type);
            this.pattern = this.getTrimPattern(pattern);
        }

        private TrimMaterial getTrimType(String name) throws ItemLoadException {
            for (TrimMaterial type : this.types) {
                if (!name.equalsIgnoreCase(type.getKey().getKey())) continue;
                return type;
            }
            throw new ItemLoadException("Invalid armor trim type such as '" + name + "'. Valid values are: " + Arrays.toString(Arrays.stream(this.types).map(t -> t.getKey().getKey().toUpperCase(Locale.ENGLISH)).toArray()));
        }

        private TrimPattern getTrimPattern(String name) throws ItemLoadException {
            for (TrimPattern pattern : this.patterns) {
                if (!name.equalsIgnoreCase(pattern.getKey().getKey())) continue;
                return pattern;
            }
            throw new ItemLoadException("Invalid armor trim pattern such as '" + name + "'. Valid values are: " + Arrays.toString(Arrays.stream(this.patterns).map(p -> p.getKey().getKey().toUpperCase(Locale.ENGLISH)).toArray()));
        }

        public ItemStack build(ItemStack stack) throws ItemLoadException {
            if (!(stack.getItemMeta() instanceof ArmorMeta)) {
                throw new ItemLoadException("To add a armor trim to an item, the material needs to be a armor piece.");
            }
            ArmorMeta meta = (ArmorMeta)stack.getItemMeta();
            meta.setTrim(new org.bukkit.inventory.meta.trim.ArmorTrim(this.type, this.pattern));
            stack.setItemMeta((ItemMeta)meta);
            return stack;
        }
    }

    public static enum Stew {
        NIGHT_VISION(0, 100, new String[0]),
        JUMP(1, 120, "JUMP_BOOST"),
        WEAKNESS(2, 180, new String[0]),
        BLINDNESS(3, 160, new String[0]),
        POISON(4, 240, new String[0]),
        SATURATION(6, 12, new String[0]),
        FIRE_RESISTANCE(7, 80, new String[0]),
        REGENERATION(8, 160, "REGEN"),
        WITHER(9, 160, new String[0]);

        private final int id;
        private final int duration;
        private final String[] aliases;

        private Stew(int id, int duration, String ... aliases) {
            this.id = id;
            this.duration = duration;
            this.aliases = aliases;
        }

        public static Stew get(String s) {
            for (Stew stew : Stew.values()) {
                if (!stew.name().equalsIgnoreCase(s.replace(" ", "_")) && !stew.anyMatchAliases(s)) continue;
                return stew;
            }
            try {
                int id = Integer.parseInt(s);
                for (Stew stew : Stew.values()) {
                    if (stew.id != id) continue;
                    return stew;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }

        private boolean anyMatchAliases(String name) {
            for (String alias : this.aliases) {
                if (!name.equalsIgnoreCase(alias.replace(" ", "_"))) continue;
                return true;
            }
            return false;
        }

        public PotionEffect parseEffect() {
            try {
                return new PotionEffect(PotionEffectType.getByName((String)this.name()), this.duration, 1);
            }
            catch (NullPointerException e) {
                return null;
            }
        }
    }
}

