/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.CalculateAmount;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.providers.priceModifiers.seasons.SeasonProvider;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class LoreFormatter {
    private final EconomyShopGUI plugin;
    private final List<DisplayLore> displayLore;
    private final List<StaticLore> itemLore;

    public LoreFormatter(EconomyShopGUI plugin) {
        ConfigurationSection config;
        this.plugin = plugin;
        List arrangement = ConfigManager.getConfig().getStringList("lore-arrangement");
        int index = arrangement.indexOf("item-lore");
        if (index == -1) {
            SendMessage.warnMessage("Failed to load lore arrangement, cannot find 'item-lore' which is required!");
            arrangement = ConfigManager.getConfig().getDef().getStringList("lore-arrangement");
            index = arrangement.indexOf("item-lore");
        }
        String path = "display-lore-layout.";
        ArrayList<DisplayLore> displayLore = new ArrayList<DisplayLore>();
        for (String section : arrangement) {
            int i = arrangement.indexOf(section);
            config = null;
            if (!section.equals("item-lore") && (config = ConfigManager.getConfig().getConfigurationSection(path + section)) == null) {
                SendMessage.warnMessage("Cannot find lore format for %part% inside config.yml, using default...".replace("%part%", section));
                config = ConfigManager.getConfig().getDef().getConfigurationSection(path + section);
            }
            switch (section) {
                case "special-lore": {
                    displayLore.add(new SpecialLore(config, i > index));
                    break;
                }
                case "buy-prices": {
                    displayLore.add(new BuyLore(config, i > index));
                    break;
                }
                case "sell-prices": {
                    displayLore.add(new SellLore(config, i > index));
                    break;
                }
                case "decoration-lore": {
                    displayLore.add(new DecorationLore(config));
                    break;
                }
                case "item-lore": {
                    displayLore.add(new ItemLore());
                    break;
                }
                case "admin-lore": {
                    displayLore.add(new AdminLore(config, i > index));
                }
            }
        }
        this.displayLore = displayLore;
        ArrayList<StaticLore> itemLore = new ArrayList<StaticLore>();
        block41: for (String section : arrangement) {
            config = ConfigManager.getConfig().getConfigurationSection(path + section);
            if (config == null && !section.equals("item-lore")) {
                SendMessage.warnMessage("Cannot find lore format for %part% inside config.yml, using default...".replace("%part%", section));
                config = ConfigManager.getConfig().getDef().getConfigurationSection(path + section);
            }
            switch (section) {
                case "buy-prices": {
                    itemLore.add(new StaticLore(LoreType.BUY_LORE, config.getStringList("normal")));
                    break;
                }
                case "sell-prices": {
                    itemLore.add(new StaticLore(LoreType.SELL_LORE, config.getStringList("normal")));
                    if (!this.plugin.MMB || Lang.SHIFT_RIGHT_CLICK_SELL_ALL.get().isEmpty()) break;
                    itemLore.add(new StaticLore(LoreType.SELL_ALL_LORE, config.getStringList("sell-all")));
                    break;
                }
                case "decoration-lore": {
                    for (String s : ConfigManager.getConfig().getConfigurationSection(path + section).getKeys(false)) {
                        List lore = ConfigManager.getConfig().getStringList(path + section + "." + s);
                        if (lore.isEmpty()) continue;
                        switch (s) {
                            case "extra-lore": {
                                itemLore.add(new StaticLore(LoreType.DECORATION_LORE, lore));
                                break;
                            }
                            case "extra-buy-lore": {
                                itemLore.add(new StaticLore(LoreType.DECORATION_LORE_BUY, lore));
                                break;
                            }
                            case "extra-sell-all-lore": {
                                if (!this.plugin.MMB || Lang.SHIFT_RIGHT_CLICK_SELL_ALL.get().isEmpty()) break;
                                itemLore.add(new StaticLore(LoreType.DECORATION_LORE_SELL_ALL, lore));
                                break;
                            }
                            case "extra-sell-lore": {
                                itemLore.add(new StaticLore(LoreType.DECORATION_LORE_SELL, lore));
                            }
                        }
                    }
                    continue block41;
                }
                case "item-lore": {
                    itemLore.add(new StaticLore(LoreType.ITEM_LORE, (List<String>)null));
                }
            }
        }
        this.itemLore = itemLore;
    }

    public ItemStack format(ShopItem shopItem, ItemStack item, Player p, String section, boolean fast, boolean discounts, boolean multipliers, boolean itemIndex, boolean seasonal) {
        Lore lore = fast ? new FastLore(item) : new ShopLore(item);
        for (DisplayLore e : this.displayLore) {
            if (e instanceof ItemLore) {
                lore.addAll(shopItem.getLore().get(fast));
                continue;
            }
            if (e instanceof BuyLore || e instanceof SellLore) {
                if (shopItem.isHidePricingLore() || shopItem.hasItemError() || shopItem.isDisplayItem()) continue;
                e.apply(shopItem, p, lore, section, fast, discounts, multipliers, seasonal);
                continue;
            }
            if (e instanceof AdminLore) {
                e.apply(shopItem, p, lore, section, fast, itemIndex);
                continue;
            }
            if (e instanceof SpecialLore) {
                e.apply(shopItem, p, lore, section, fast, seasonal);
                continue;
            }
            if (!(e instanceof DecorationLore)) continue;
            e.apply(shopItem, p, lore, section, fast, new boolean[0]);
        }
        return lore.form();
    }

    public List<StaticLore> getItemLore() {
        return this.itemLore;
    }

    private void addLore(ShopItem shopItem, FastLore lore, String s, int i, boolean after) {
        if (after) {
            this.plugin.versionHandler.addItemLore(lore, s);
        } else {
            this.plugin.versionHandler.addItemLore(lore, s, i);
        }
    }

    private boolean isEmpty(List<String> list) {
        return list.stream().allMatch(String::isEmpty);
    }

    private String translate(String s) {
        if (s == null) {
            return "";
        }
        if (s.contains("%translations-")) {
            try {
                Lang placeholder = Lang.valueOf(s.split("%translations-")[1].split("%")[0].toUpperCase(Locale.ENGLISH).replace("-", "_"));
                s = s.replace("%translations-" + placeholder.getKey() + "%", placeholder.get());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.plugin.formatColors(s);
    }

    private List<String> translate(List<String> list) {
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<String> lore = new ArrayList<String>();
        for (String s : list) {
            if (s.contains("%translations-")) {
                try {
                    Lang placeholder = Lang.valueOf(s.split("%translations-")[1].split("%")[0].toUpperCase(Locale.ENGLISH).replace("-", "_"));
                    s = s.replace("%translations-" + placeholder.getKey() + "%", placeholder.get());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            for (String e : s.split("\n")) {
                lore.add(this.plugin.formatColors(e));
            }
        }
        return lore;
    }

    private final class SpecialLore
    implements DisplayLore {
        private final DynamicLore seasonalPrice;
        private final boolean after;

        public SpecialLore(ConfigurationSection section, boolean after) {
            this.after = after;
            this.seasonalPrice = new DynamicLore(section.getString("seasonal-pricing"), Lang.ITEM_SEASONAL_PRICE.get());
        }

        @Override
        public void apply(ShopItem shopItem, Player p, Lore lore, String section, boolean fast, boolean ... data) {
            if (data[0]) {
                lore.add(this.seasonalPrice.get(fast).replace("%season-icon%", SeasonProvider.getSeason(p.getWorld().getName()).getIcon()).replace("%season-name%", SeasonProvider.getSeason(p.getWorld().getName()).getName()));
            }
        }
    }

    private final class BuyLore
    implements DisplayLore {
        private final DynamicLoreList disabled;
        private final DynamicLoreList undefined;
        private final DynamicLoreList buyPrices;
        private final DynamicLoreList seasonalBuyPrices;
        private final DynamicLoreList discountedBuyPrices;
        private final boolean after;

        public BuyLore(ConfigurationSection section, boolean after) {
            this.after = after;
            this.disabled = new DynamicLoreList(section.getStringList("disabled"), Lang.ITEM_CANNOT_BE_BOUGHT.get());
            this.undefined = new DynamicLoreList(section.getStringList("undefined"), "");
            this.buyPrices = new DynamicLoreList(section.getStringList("normal"), Lang.LEFT_CLICK_BUY.get(), "%buyPrice%");
            this.seasonalBuyPrices = new DynamicLoreList(section.getStringList("seasonal"), Lang.SEASONAL_BUY_PRICE.get(), "%seasonalBuyPrice%");
            this.discountedBuyPrices = new DynamicLoreList(section.getStringList("discounted"), Lang.DISCOUNTED_BUY_PRICE.get(), "%discountedPrice%");
        }

        @Override
        public void apply(ShopItem shopItem, Player p, Lore lore, String section, boolean fast, boolean ... data) {
            if (shopItem.getBuyPrice() >= 0.0) {
                if (shopItem.isBuyLore()) {
                    if (data[2]) {
                        String s = this.seasonalBuyPrices.get(fast)[this.seasonalBuyPrices.index].replace("%buyPrice%", LoreFormatter.this.plugin.formatPrice(shopItem.getEcoType(), shopItem.getBuyPrice() * (double)shopItem.getStackSize())).replace("%seasonalBuyPrice%", LoreFormatter.this.plugin.formatPrice(shopItem.getEcoType(), shopItem.getBuyPrice(p) * (double)shopItem.getStackSize()));
                        lore.addAll(this.seasonalBuyPrices.get(s, fast));
                    } else if (data[0] && CalculateAmount.calculateDiscount(p, section, shopItem.getBuyPrice()) != shopItem.getBuyPrice()) {
                        String s = this.discountedBuyPrices.get(fast)[this.discountedBuyPrices.index].replace("%buyPrice%", LoreFormatter.this.plugin.formatPrice(shopItem.getEcoType(), shopItem.getBuyPrice() * (double)shopItem.getStackSize())).replace("%discountedPrice%", LoreFormatter.this.plugin.formatPrice(shopItem.getEcoType(), shopItem.getBuyPrice(p) * (double)shopItem.getStackSize()));
                        lore.addAll(this.discountedBuyPrices.get(s, fast));
                    } else {
                        String s = this.buyPrices.get(fast)[this.buyPrices.index].replace("%buyPrice%", LoreFormatter.this.plugin.formatPrice(shopItem.getEcoType(), shopItem.getBuyPrice() * (double)shopItem.getStackSize()));
                        lore.addAll(this.buyPrices.get(s, fast));
                    }
                } else {
                    lore.addAll(this.undefined.get(fast));
                }
            } else {
                lore.addAll(this.disabled.get(fast));
            }
        }
    }

    private final class SellLore
    implements DisplayLore {
        private final DynamicLoreList disabled;
        private final DynamicLoreList undefined;
        private final DynamicLoreList sellPrices;
        private final DynamicLoreList seasonalSellPrices;
        private final DynamicLoreList multipliedSellPrices;
        private final DynamicLoreList sellAllLore;
        private final boolean after;

        public SellLore(ConfigurationSection section, boolean after) {
            this.after = after;
            this.disabled = new DynamicLoreList(section.getStringList("disabled"), Lang.ITEM_CANNOT_BE_SOLD.get());
            this.undefined = new DynamicLoreList(section.getStringList("undefined"), "");
            this.sellPrices = new DynamicLoreList(section.getStringList("normal"), Lang.RIGHT_CLICK_SELL.get(), "%sellPrice%");
            this.seasonalSellPrices = new DynamicLoreList(section.getStringList("seasonal"), Lang.SEASONAL_SELL_PRICE.get(), "%seasonalSellPrice%");
            this.multipliedSellPrices = new DynamicLoreList(section.getStringList("multiplied"), Lang.MULTIPLIED_SELL_PRICE.get(), "%multipliedPrice%");
            this.sellAllLore = new DynamicLoreList(section.getStringList("sell-all"), Lang.SHIFT_RIGHT_CLICK_SELL_ALL.get());
        }

        @Override
        public void apply(ShopItem shopItem, Player p, Lore lore, String section, boolean fast, boolean ... data) {
            if (shopItem.getSellPrice() >= 0.0) {
                if (shopItem.isSellLore()) {
                    if (data[2]) {
                        String s = this.seasonalSellPrices.get(fast)[this.seasonalSellPrices.index].replace("%sellPrice%", LoreFormatter.this.plugin.formatPrice(shopItem.getEcoType(), shopItem.getSellPrice() * (double)shopItem.getStackSize())).replace("%seasonalSellPrice%", LoreFormatter.this.plugin.formatPrice(shopItem.getEcoType(), shopItem.getSellPrice(p) * (double)shopItem.getStackSize()));
                        lore.addAll(this.seasonalSellPrices.get(s, fast));
                    } else if (data[1] && CalculateAmount.calculateMultiplier(p, section, shopItem.getSellPrice()) != shopItem.getSellPrice()) {
                        String s = this.multipliedSellPrices.get(fast)[this.multipliedSellPrices.index].replace("%sellPrice%", LoreFormatter.this.plugin.formatPrice(shopItem.getEcoType(), shopItem.getSellPrice() * (double)shopItem.getStackSize())).replace("%multipliedPrice%", LoreFormatter.this.plugin.formatPrice(shopItem.getEcoType(), shopItem.getSellPrice(p) * (double)shopItem.getStackSize()));
                        lore.addAll(this.multipliedSellPrices.get(s, fast));
                    } else {
                        String s = this.sellPrices.get(fast)[this.sellPrices.index].replace("%sellPrice%", LoreFormatter.this.plugin.formatPrice(shopItem.getEcoType(), shopItem.getSellPrice() * (double)shopItem.getStackSize()));
                        lore.addAll(this.sellPrices.get(s, fast));
                    }
                    if (((LoreFormatter)LoreFormatter.this).plugin.MMB) {
                        lore.addAll(this.sellAllLore.get(fast));
                    }
                } else {
                    lore.addAll(this.undefined.get(fast));
                }
            } else {
                lore.addAll(this.disabled.get(fast));
            }
        }
    }

    private final class DecorationLore
    implements DisplayLore {
        private final DynamicLoreList lore;
        private final DynamicLoreList buyLore;
        private final DynamicLoreList sellLore;
        private final DynamicLoreList sellAllLore;

        public DecorationLore(ConfigurationSection section) {
            this.lore = new DynamicLoreList(section.getStringList("extra-lore"), "");
            this.buyLore = new DynamicLoreList(section.getStringList("extra-buy-lore"), "");
            this.sellLore = new DynamicLoreList(section.getStringList("extra-sell-lore"), "");
            this.sellAllLore = new DynamicLoreList(section.getStringList("extra-sell-all-lore"), "");
        }

        @Override
        public void apply(ShopItem shopItem, Player p, Lore lore, String section, boolean fast, boolean ... data) {
            if (shopItem.isDecorationLore()) {
                lore.addAll(this.lore.get(fast));
                if (shopItem.getBuyPrice() >= 0.0 && shopItem.isBuyLore()) {
                    lore.addAll(this.buyLore.get(fast));
                }
                if (shopItem.getSellPrice() >= 0.0 && shopItem.isSellLore()) {
                    if (((LoreFormatter)LoreFormatter.this).plugin.MMB) {
                        lore.addAll(this.sellAllLore.get(fast));
                    }
                    lore.addAll(this.sellLore.get(fast));
                }
            }
        }
    }

    private final class ItemLore
    implements DisplayLore {
        @Override
        public void apply(ShopItem shopItem, Player p, Lore lore, String section, boolean fast, boolean ... data) {
        }
    }

    private final class AdminLore
    implements DisplayLore {
        private final DynamicLore itemIndex;
        private final boolean after;

        public AdminLore(ConfigurationSection section, boolean after) {
            this.after = after;
            this.itemIndex = new DynamicLore(section.getString("item-index"), Lang.ITEM_LOCATION_IN_SHOP.get());
        }

        @Override
        public void apply(ShopItem shopItem, Player p, Lore lore, String section, boolean fast, boolean ... data) {
            if (data[0]) {
                lore.add(this.itemIndex.get(fast).replace("%shopsection%", section).replace("%itemLoc%", shopItem.itemLoc));
            }
        }
    }

    public final class StaticLore {
        public final LoreType type;
        public final List<String> lore;

        public StaticLore(LoreType type, String[] lore) {
            this.type = type;
            this.lore = lore == null && type == LoreType.ITEM_LORE ? null : LoreFormatter.this.translate(type == LoreType.BUY_LORE || type == LoreType.SELL_LORE ? Arrays.stream(lore).map(s -> s.replace("%dpp%", "")).collect(Collectors.toList()) : Arrays.asList(lore));
        }

        public StaticLore(LoreType type, List<String> lore) {
            this.type = type;
            this.lore = lore == null && type == LoreType.ITEM_LORE ? null : (type == LoreType.BUY_LORE || type == LoreType.SELL_LORE ? LoreFormatter.this.translate(lore).stream().map(s -> s.replace("%dpp%", "")).collect(Collectors.toList()) : LoreFormatter.this.translate(lore));
        }
    }

    public static enum LoreType {
        BUY_LORE,
        SELL_LORE,
        SELL_ALL_LORE,
        DECORATION_LORE,
        DECORATION_LORE_BUY,
        DECORATION_LORE_SELL,
        DECORATION_LORE_SELL_ALL,
        ITEM_LORE;

    }

    private final class FastLore
    implements Lore {
        private final Object lore;
        private final ItemStack stack;

        public FastLore(ItemStack item) {
            this.lore = ((LoreFormatter)LoreFormatter.this).plugin.versionHandler.emptyList();
            this.stack = item;
        }

        @Override
        public void add(String s) {
            ((LoreFormatter)LoreFormatter.this).plugin.versionHandler.addItemLore(this.lore, s);
        }

        public void add(String s, int i) {
            ((LoreFormatter)LoreFormatter.this).plugin.versionHandler.addItemLore(this.lore, s, i);
        }

        @Override
        public void addAll(String[] list) {
            for (String s : list) {
                this.add(s);
            }
        }

        @Override
        public ItemStack form() {
            return ((LoreFormatter)LoreFormatter.this).plugin.versionHandler.applyNMSLore(this.stack, this.lore);
        }
    }

    private final class ShopLore
    implements Lore {
        private final List<String> lore = new ArrayList<String>();
        private final ItemStack stack;

        public ShopLore(ItemStack item) {
            this.stack = item;
        }

        @Override
        public void add(String s) {
            this.lore.add(s);
        }

        public void add(String s, int i) {
            this.lore.add(i, s);
        }

        @Override
        public void addAll(String[] list) {
            for (String s : list) {
                this.add(s);
            }
        }

        @Override
        public ItemStack form() {
            ItemMeta meta = this.stack.getItemMeta();
            meta.setLore(this.lore);
            this.stack.setItemMeta(meta);
            return this.stack;
        }
    }

    private static interface DisplayLore {
        public void apply(ShopItem var1, Player var2, Lore var3, String var4, boolean var5, boolean ... var6);
    }

    private static interface Lore {
        public void addAll(String[] var1);

        public void add(String var1);

        public ItemStack form();
    }

    private final class DynamicLoreList {
        private final String[] lore;
        private final String[] fastLore;
        private int index = 0;

        public DynamicLoreList(List<String> list, String def) {
            this.lore = list != null ? (!LoreFormatter.this.isEmpty(list) ? LoreFormatter.this.translate(list).toArray(new String[list.size()]) : new String[]{}) : LoreFormatter.this.translate(def).split("\n");
            this.fastLore = (String[])Arrays.stream(this.lore).map(s -> ((LoreFormatter)LoreFormatter.this).plugin.versionHandler.toNBT((String)s)).toArray(String[]::new);
        }

        public DynamicLoreList(List<String> list, String def, String ph) {
            this.lore = list != null ? (!LoreFormatter.this.isEmpty(list) ? LoreFormatter.this.translate(list).toArray(new String[list.size()]) : new String[]{}) : LoreFormatter.this.translate(def).split("\n");
            this.fastLore = (String[])Arrays.stream(this.lore).map(s -> ((LoreFormatter)LoreFormatter.this).plugin.versionHandler.toNBT((String)s)).toArray(String[]::new);
            for (int i = 0; i < this.lore.length; ++i) {
                if (!this.lore[i].contains(ph)) continue;
                this.index = i;
            }
        }

        private String[] get(boolean fast) {
            return fast ? this.fastLore : this.lore;
        }

        private String[] getAll(boolean fast) {
            return (String[])(fast ? this.fastLore : this.lore).clone();
        }

        public String[] get(String s, boolean fast) {
            String[] lore = (String[])this.get(fast).clone();
            lore[this.index] = s;
            return lore;
        }
    }

    private final class DynamicLore {
        private final String lore;
        private final String fastLore;

        public DynamicLore(String s, String def) {
            this.lore = s != null ? LoreFormatter.this.translate(s) : def;
            this.fastLore = ((LoreFormatter)LoreFormatter.this).plugin.versionHandler.toNBT(this.lore);
        }

        public DynamicLore(String s, String def, String ph) {
            this.lore = Arrays.stream((s != null ? LoreFormatter.this.translate(s) : def).split("\n")).filter(e -> e.contains(ph)).findFirst().orElseGet(() -> (s != null ? LoreFormatter.this.translate(s) : def).split("\n")[0]);
            this.fastLore = ((LoreFormatter)LoreFormatter.this).plugin.versionHandler.toNBT(this.lore);
        }

        public DynamicLore(List<String> list, String def, String ph) {
            this.lore = (list != null ? LoreFormatter.this.translate(list) : Collections.singletonList(def)).stream().filter(e -> e.contains(ph)).findFirst().orElseGet(() -> (String)(list != null ? LoreFormatter.this.translate(list) : Collections.singletonList(def)).get(0));
            this.fastLore = ((LoreFormatter)LoreFormatter.this).plugin.versionHandler.toNBT(this.lore);
        }

        public String get(boolean nbt) {
            return nbt ? this.fastLore : this.lore;
        }
    }
}

