/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.objects.navbar;

import java.util.HashMap;
import java.util.Map;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.methodes.CreateItem;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.objects.MainMenu;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.objects.ShopPage;
import me.gypopo.economyshopgui.objects.ShopSection;
import me.gypopo.economyshopgui.objects.TransactionMenu;
import me.gypopo.economyshopgui.objects.navbar.NavBarItem;
import me.gypopo.economyshopgui.util.EcoType;
import me.gypopo.economyshopgui.util.Transaction;
import me.gypopo.economyshopgui.util.exceptions.ItemLoadException;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class NavBar
extends CreateItem {
    private final EconomyShopGUI plugin;
    public boolean enableMainNav;
    private final Map<String, ShopNavBar> shopNavBars = new HashMap<String, ShopNavBar>();
    private final Map<Integer, NavBarItem> mainMenuNavBar = new HashMap<Integer, NavBarItem>();
    private final Map<Integer, NavBarItem> shopsNavBar = new HashMap<Integer, NavBarItem>();
    private final Map<Integer, NavBarItem> transactionNavBar = new HashMap<Integer, NavBarItem>();
    private final Map<Integer, NavBarItem> sellGUINavBar = new HashMap<Integer, NavBarItem>();

    public NavBar(EconomyShopGUI plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    public boolean isEnabled(String shop) {
        if (this.shopNavBars.containsKey(shop)) {
            return this.shopNavBars.get(shop).enabled;
        }
        return !this.shopsNavBar.isEmpty();
    }

    public boolean isEnableMainNav() {
        return !this.mainMenuNavBar.isEmpty();
    }

    public boolean isEnableTransactionNav() {
        return !this.transactionNavBar.isEmpty();
    }

    public boolean isEnableSellGUINav() {
        return !this.sellGUINavBar.isEmpty();
    }

    public void execute(Player player, ShopPage page, int i, int cp, boolean disabledBackButton) {
        NavBarItem item = this.getItem(page.getSection(), i - (page.getSize() - 9));
        if (item == null) {
            return;
        }
        switch (item.getAction(page.getAllPages())) {
            case "BACK": {
                if (disabledBackButton) break;
                if (page.isSubSection()) {
                    this.plugin.getSection(page.getRootSection()).openShopSection(player, disabledBackButton);
                    break;
                }
                new MainMenu(player);
                break;
            }
            case "PAGE_BACK": {
                if (cp <= 1) break;
                this.plugin.getSection(page.getSection()).openShopSection(player, cp - 1, disabledBackButton);
                break;
            }
            case "PAGE_NEXT": {
                if (cp == this.plugin.getSection(page.getSection()).getPages()) break;
                this.plugin.getSection(page.getSection()).openShopSection(player, cp + 1, disabledBackButton);
                break;
            }
            case "CLOSE": {
                player.closeInventory();
            }
        }
    }

    private NavBarItem getItem(String shop, int i) {
        return this.shopNavBars.containsKey(shop) ? this.shopNavBars.get(shop).get(i) : this.shopsNavBar.get(i);
    }

    public void execute(Player player, int i) {
        String action = this.mainMenuNavBar.get(i).getAction();
        if (action == null) {
            return;
        }
        switch (action) {
            case "BACK": 
            case "CLOSE": {
                player.closeInventory();
            }
        }
    }

    public void execute(Player player, ShopItem shopItem, int i, boolean disabledBackButton, Transaction.Mode transactionMode, Transaction.Type transactionType, int amount) {
        String action = this.transactionNavBar.get(i).getAction();
        if (action == null) {
            return;
        }
        switch (action) {
            case "TOGGLE_MODE": {
                new TransactionMenu(player, shopItem, disabledBackButton, transactionMode == Transaction.Mode.BUY ? Transaction.Mode.SELL : Transaction.Mode.BUY, transactionMode == Transaction.Mode.BUY ? Transaction.Type.SELL_SCREEN : Transaction.Type.BUY_SCREEN, amount).open();
                break;
            }
            case "BACK": {
                if (transactionType != Transaction.Type.BUY_STACKS_SCREEN) {
                    ShopSection section = this.plugin.getSection(shopItem.section);
                    section.openShopSection(player, section.getPageForShopItem(shopItem.itemLoc), disabledBackButton);
                    break;
                }
                new TransactionMenu(player, shopItem, disabledBackButton, transactionMode, Transaction.Type.BUY_SCREEN, amount).open();
                break;
            }
            case "CLOSE": {
                player.closeInventory();
            }
        }
    }

    public void createMainMenuNavBar() {
        if (!this.mainMenuNavBar.isEmpty()) {
            this.mainMenuNavBar.clear();
        }
        this.mainMenuNavBar.putAll(this.getDefaultNavBar("main-menu-nav-bar"));
    }

    public void createShopsNavBar() {
        if (!this.shopsNavBar.isEmpty()) {
            this.shopsNavBar.clear();
        }
        if (!this.shopNavBars.isEmpty()) {
            this.shopNavBars.clear();
        }
        this.shopsNavBar.putAll(this.getDefaultNavBar("shops-nav-bar"));
        this.plugin.getShopSections().forEach(this::loadShopNavBar);
    }

    private void loadShopNavBar(String section) {
        if (ConfigManager.getSection(section).getString("nav-bar.mode", "INHERIT").equalsIgnoreCase("INHERIT")) {
            return;
        }
        this.shopNavBars.put(section, new ShopNavBar(section));
    }

    public void createTransactionNavBar() {
        if (!this.transactionNavBar.isEmpty()) {
            this.transactionNavBar.clear();
        }
        this.transactionNavBar.putAll(this.getDefaultNavBar("transaction-screens-nav-bar"));
    }

    public void createSellGUINavBar() {
        if (!this.sellGUINavBar.isEmpty()) {
            this.sellGUINavBar.clear();
        }
        this.sellGUINavBar.putAll(this.getDefaultNavBar("sellgui-nav-bar"));
    }

    private Map<Integer, NavBarItem> getDefaultNavBar(String path) {
        HashMap<Integer, NavBarItem> items = new HashMap<Integer, NavBarItem>();
        if (!ConfigManager.getConfig().getBoolean(path + ".enabled", true)) {
            return items;
        }
        ConfigurationSection section = ConfigManager.getConfig().getConfigurationSection(path + ".items");
        if (section == null || section.getKeys(false).isEmpty()) {
            return items;
        }
        int i = 1;
        for (String item : section.getKeys(false)) {
            if (ConfigManager.getConfig().getConfigurationSection(path + ".items." + item) == null) continue;
            try {
                int slot;
                NavBarItem nbi;
                block13: {
                    nbi = this.getDefaultItem(path + ".items." + item);
                    slot = 0;
                    try {
                        if (ConfigManager.getConfig().contains(path + ".items." + item + ".slot")) {
                            slot = ConfigManager.getConfig().getInt(path + ".items." + item + ".slot");
                            break block13;
                        }
                        try {
                            slot = Integer.parseInt(item);
                            while (items.containsKey(slot - 1)) {
                                ++slot;
                            }
                        }
                        catch (NumberFormatException e) {
                            slot = i;
                            while (items.containsKey(slot - 1)) {
                                ++slot;
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        SendMessage.warnMessage("Cannot create navigation bar item at '" + path + "." + item + "' because the slot is not a valid integer. Got '" + ConfigManager.getConfig().getString(path + "." + item + ".slot") + "'");
                    }
                }
                if (slot > 9 || slot < 1) {
                    SendMessage.warnMessage("Cannot create navigation bar item at '" + path + "." + item + "' because the slot is out of bounds for " + slot + ". Valid values should be in range of 1-9");
                    continue;
                }
                items.put(slot - 1, nbi);
                ++i;
            }
            catch (ItemLoadException itemLoadException) {}
        }
        return items;
    }

    private NavBarItem getDefaultItem(String path) throws ItemLoadException {
        try {
            return this.getNavBarItem(ConfigManager.getConfig().getConfigurationSection(path));
        }
        catch (ItemLoadException e) {
            SendMessage.logDebugMessage(e.getMessage());
            SendMessage.errorItemConfig(path);
            return new NavBarItem(ConfigManager.getConfig().getDef().getConfigurationSection(path));
        }
    }

    private NavBarItem getShopItem(String shop, String path) {
        try {
            return this.getNavBarItem(ConfigManager.getSection(shop).getConfigurationSection(path));
        }
        catch (ItemLoadException e) {
            SendMessage.logDebugMessage(e.getMessage());
            SendMessage.errorSections(shop, path);
            return null;
        }
    }

    private NavBarItem getNavBarItem(ConfigurationSection section) throws ItemLoadException {
        if (section != null && !section.getKeys(false).isEmpty()) {
            return new NavBarItem(section);
        }
        throw new ItemLoadException("Could not create the navigation-bar item because it was not found.");
    }

    public Inventory addShopsNavBar(Inventory inv, Player p, String section, int page, int allpages) {
        if (this.shopNavBars.containsKey(section)) {
            return this.shopNavBars.get(section).load(inv, p, section, page, allpages);
        }
        for (Map.Entry<Integer, NavBarItem> e : this.shopsNavBar.entrySet()) {
            inv.setItem(inv.getSize() - 9 + e.getKey(), e.getValue().getItem(p, this.plugin.getEcoHandler().getEcon(section).getType(), page, allpages));
        }
        return inv;
    }

    public Inventory addMainMenuNavBar(Inventory inv, Player p) {
        for (Map.Entry<Integer, NavBarItem> e : this.mainMenuNavBar.entrySet()) {
            inv.setItem(inv.getSize() - 9 + e.getKey(), e.getValue().getItem(p, null));
        }
        return inv;
    }

    public Inventory addTransactionNavBar(Inventory inv, Player p, EcoType type) {
        for (Map.Entry<Integer, NavBarItem> e : this.transactionNavBar.entrySet()) {
            NavBarItem item = e.getValue();
            if (item.isDisabled()) continue;
            inv.setItem(inv.getSize() - 9 + e.getKey(), item.getItem(p, type));
        }
        return inv;
    }

    public Inventory addSellGUINavBar(Inventory inv, Player p) {
        for (Map.Entry<Integer, NavBarItem> e : this.sellGUINavBar.entrySet()) {
            inv.setItem(inv.getSize() - 9 + e.getKey(), e.getValue().getItem(p, null));
        }
        return inv;
    }

    private class ShopNavBar {
        private final String shop;
        private boolean enabled;
        private final ItemStack fillItem;
        private final Map<Integer, NavBarItem> items = new HashMap<Integer, NavBarItem>();

        public NavBarItem get(int i) {
            return this.items.get(i);
        }

        public ShopNavBar(String shop) {
            this.shop = shop;
            this.enabled = !ConfigManager.getSection(shop).getString("nav-bar.mode", "INHERIT").equalsIgnoreCase("DISABLED");
            this.fillItem = ConfigManager.getSection(this.shop).contains("nav-bar.fill-item") ? ((NavBar)NavBar.this).plugin.createItem.createFillItem(this.shop, ConfigManager.getSection(this.shop).getConfigurationSection("nav-bar.fill-item")) : null;
            ConfigurationSection section = ConfigManager.getSection(this.shop).getConfigurationSection("nav-bar.items");
            if (section == null || section.getKeys(false).isEmpty()) {
                this.enabled = false;
                return;
            }
            int i = 1;
            for (String item : section.getKeys(false)) {
                int slot;
                NavBarItem nbi;
                block12: {
                    nbi = NavBar.this.getShopItem(this.shop, "nav-bar.items." + item);
                    if (nbi == null) {
                        nbi = (NavBarItem)NavBar.this.shopsNavBar.get(i);
                    }
                    slot = 0;
                    try {
                        if (ConfigManager.getSection(this.shop).contains("nav-bar.items." + item + ".slot")) {
                            slot = ConfigManager.getSection(this.shop).getInt("nav-bar.items." + item + ".slot");
                            break block12;
                        }
                        try {
                            slot = Integer.parseInt(item);
                            while (this.items.containsKey(slot - 1)) {
                                ++slot;
                            }
                        }
                        catch (NumberFormatException e) {
                            slot = i;
                            while (this.items.containsKey(slot - 1)) {
                                ++slot;
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        SendMessage.warnMessage("Cannot create navigation bar item for shop '" + this.shop + "' at 'nav-bar.items." + item + "' because the slot is not a valid integer. Got '" + ConfigManager.getSection(this.shop).getInt("nav-bar.items." + item + ".slot") + "'");
                    }
                }
                if (slot > 9 || slot < 1) {
                    SendMessage.warnMessage("Cannot create navigation bar item for shop '" + this.shop + "' at 'nav-bar.items." + item + "' because the slot is out of bounds for " + slot + ". Valid values should be in range of 1-9");
                    continue;
                }
                this.items.put(slot - 1, nbi);
                ++i;
            }
            if (this.items.isEmpty()) {
                this.enabled = false;
            }
        }

        public Inventory load(Inventory inv, Player p, String section, int page, int allpages) {
            if (!this.enabled) {
                return inv;
            }
            for (Map.Entry<Integer, NavBarItem> e : this.items.entrySet()) {
                inv.setItem(inv.getSize() - 9 + e.getKey(), e.getValue().getItem(p, NavBar.this.plugin.getEcoHandler().getEcon(section).getType(), page, allpages));
            }
            if (this.fillItem != null) {
                for (int i = 0; i < 9; ++i) {
                    if (this.items.containsKey(i)) continue;
                    inv.setItem(inv.getSize() - 9 + i, this.fillItem);
                }
            }
            return inv;
        }
    }
}

