/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.objects.navbar;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.CreateItemMethodes;
import me.gypopo.economyshopgui.providers.UserManager;
import me.gypopo.economyshopgui.util.EcoType;
import me.gypopo.economyshopgui.util.SkullUtil;
import me.gypopo.economyshopgui.util.XMaterial;
import me.gypopo.economyshopgui.util.exceptions.ItemLoadException;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class NavBarItem {
    private ItemStack navBarItem;
    private String action = null;
    private String skullOwner;
    private boolean staticItem = true;
    private boolean onlyGeyser;
    private boolean disabled;
    private Paginated paginatedItem;

    public String getAction() {
        return this.action;
    }

    public String getAction(int pages) {
        return pages == 1 && this.paginatedItem != null && !this.paginatedItem.isDisabled() ? this.paginatedItem.getA() : this.action;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public NavBarItem(ItemStack item, String action) {
        this.navBarItem = item;
        this.action = action;
    }

    public NavBarItem(ConfigurationSection config) throws ItemLoadException {
        List l;
        String owner;
        ItemStack item = CreateItemMethodes.createItemMaterialFromString(config.getString("material"));
        if (item.getType().equals((Object)Material.AIR)) {
            this.disabled = true;
            return;
        }
        if (item.getType().equals((Object)XMaterial.PLAYER_HEAD.parseMaterial()) && (owner = config.getString("skullowner")) != null && !owner.equals("%player_name%")) {
            this.skullOwner = owner;
            this.staticItem = false;
        }
        ItemMeta meta = item.getItemMeta();
        String name = config.getString("name");
        if (name != null) {
            if (this.hasPlaceholder(name = this.replaceTranslations(name))) {
                this.staticItem = false;
            }
            meta.setDisplayName(EconomyShopGUI.getInstance().formatColors(name));
        }
        if (!(l = config.getStringList("lore")).isEmpty()) {
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : l) {
                if (this.hasPlaceholder(line = this.replaceTranslations(line))) {
                    this.staticItem = false;
                }
                lore.add(EconomyShopGUI.getInstance().formatColors(line));
            }
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        if (config.getBoolean("paginated.enabled")) {
            ConfigurationSection section = config.getConfigurationSection("paginated.orElse");
            this.paginatedItem = section != null && !section.getKeys(false).isEmpty() ? new Paginated(section) : new Paginated();
            this.staticItem = false;
        }
        this.action = this.getAction(config);
        this.navBarItem = item;
    }

    private String replaceTranslations(String s) {
        return s.replace("%translations-previous-page%", Lang.PREVIOUS_PAGE.get()).replace("%translations-current-page%", Lang.CURRENT_PAGE.get().contains("%page%") ? Lang.CURRENT_PAGE.get() : Lang.CURRENT_PAGE.get() + " %page%/%pages%").replace("%translations-next-page%", Lang.NEXT_PAGE.get()).replace("%translations-money%", Lang.MONEY.get()).replace("%translations-cancel%", Lang.CANCEL.get()).replace("%translations-back%", Lang.BACK.get());
    }

    private String getAction(ConfigurationSection section) {
        if (!section.contains("action")) {
            return "NONE";
        }
        switch (section.getString("action").toUpperCase(Locale.ENGLISH)) {
            case "PAGE_BACK": 
            case "PAGE_NEXT": {
                if (this.paginatedItem == null && section.getBoolean("paginated.enabled", true)) {
                    this.paginatedItem = new Paginated();
                    this.staticItem = false;
                }
            }
            case "TOGGLE_MODE": {
                this.onlyGeyser = section.getBoolean("onlyEnableForGeyserPlayers", true);
            }
            case "CLOSE": 
            case "BACK": {
                return section.getString("action").toUpperCase(Locale.ENGLISH);
            }
        }
        return null;
    }

    public ItemStack getItem(Player p, EcoType type, int page, int allpages) {
        ItemMeta meta;
        if (this.staticItem) {
            return this.navBarItem;
        }
        if (this.paginatedItem != null && allpages == 1) {
            return this.paginatedItem.getItem(p, type, page, allpages);
        }
        ItemStack item = new ItemStack(this.navBarItem);
        if (!item.hasItemMeta()) {
            return item;
        }
        if (item.getType().equals((Object)XMaterial.PLAYER_HEAD.parseMaterial())) {
            SkullMeta skullMeta = (SkullMeta)item.getItemMeta();
            skullMeta.setOwner(this.skullOwner == null ? p.getName() : this.skullOwner);
            item.setItemMeta((ItemMeta)skullMeta);
        }
        if ((meta = item.getItemMeta()).hasDisplayName()) {
            meta.setDisplayName(this.replacePlaceHolders(p, meta.getDisplayName(), type, page, allpages));
        }
        if (meta.hasLore()) {
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : meta.getLore()) {
                lore.add(this.replacePlaceHolders(p, line, type, page, allpages));
            }
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack getItem(Player p, EcoType type) {
        ItemMeta meta;
        if (this.onlyGeyser && !UserManager.getUser(p).isBedrock()) {
            return new ItemStack(Material.AIR);
        }
        if (this.staticItem) {
            return this.navBarItem;
        }
        ItemStack item = new ItemStack(this.navBarItem);
        if (!item.hasItemMeta()) {
            return item;
        }
        if (item.getType().equals((Object)XMaterial.PLAYER_HEAD.parseMaterial())) {
            SkullUtil.setSkullTexture(item, null, this.skullOwner == null ? p.getName() : this.skullOwner, false);
        }
        if ((meta = item.getItemMeta()).hasDisplayName()) {
            meta.setDisplayName(this.replacePlaceHolders(p, meta.getDisplayName(), type));
        }
        if (meta.hasLore()) {
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : meta.getLore()) {
                lore.add(this.replacePlaceHolders(p, line, type));
            }
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    private boolean hasPlaceholder(String s) {
        return s.contains("%player_name%") || s.contains("player_displayname") || s.contains("%player_level%") || s.contains("%player_balance%") || s.contains("%page%") || s.contains("%pages%");
    }

    private String replacePlaceHolders(Player p, String s, EcoType type) {
        return s.replace("%player_name%", p.getName()).replace("%player_displayname%", EconomyShopGUI.getInstance().getDisplayName(p, s)).replace("%player_level%", String.valueOf(p.getLevel())).replace("%player_balance%", EconomyShopGUI.getInstance().formatPrice(type, EconomyShopGUI.getInstance().getEcoHandler().getEcon(type).getBalance((OfflinePlayer)p)));
    }

    private String replacePlaceHolders(Player p, String s, EcoType type, int page, int allpages) {
        return this.replacePlaceHolders(p, s.replace("%page%", String.valueOf(page)).replace("%pages%", String.valueOf(allpages)), type);
    }

    public class Paginated {
        private ItemStack orElse;
        private String action = null;
        private String skullOwner;
        private boolean staticItem = true;
        private boolean disabled = false;
        private List<String> commands;
        private Map<Integer, String> placeholders;

        public Paginated() {
            this.disabled = true;
            this.orElse = new ItemStack(Material.AIR);
        }

        public Paginated(ConfigurationSection config) throws ItemLoadException {
            List l;
            String owner;
            ItemStack item = CreateItemMethodes.createItemMaterialFromString(config.getString("material"));
            if (item.getType().equals((Object)Material.AIR)) {
                this.disabled = true;
                return;
            }
            if (item.getType().equals((Object)XMaterial.PLAYER_HEAD.parseMaterial()) && (owner = config.getString("skullowner")) != null && !owner.equals("%player_name%")) {
                this.skullOwner = owner;
                this.staticItem = false;
            }
            ItemMeta meta = item.getItemMeta();
            String name = config.getString("name");
            if (name != null) {
                if (NavBarItem.this.hasPlaceholder(name = NavBarItem.this.replaceTranslations(name))) {
                    this.staticItem = false;
                }
                meta.setDisplayName(EconomyShopGUI.getInstance().formatColors(name));
            }
            if (!(l = config.getStringList("lore")).isEmpty()) {
                ArrayList<String> lore = new ArrayList<String>();
                for (String line : l) {
                    if (NavBarItem.this.hasPlaceholder(line = NavBarItem.this.replaceTranslations(line))) {
                        this.staticItem = false;
                    }
                    lore.add(EconomyShopGUI.getInstance().formatColors(line));
                }
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
            this.action = NavBarItem.this.getAction(config);
            this.orElse = item;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public String getA() {
            return this.action;
        }

        public List<String> getCommands() {
            return this.commands;
        }

        public ItemStack getItem(Player p, EcoType type, int page, int allpages) {
            ItemMeta meta;
            if (this.staticItem) {
                return this.orElse;
            }
            ItemStack item = new ItemStack(this.orElse);
            if (!item.hasItemMeta()) {
                return item;
            }
            if (item.getType().equals((Object)XMaterial.PLAYER_HEAD.parseMaterial())) {
                SkullMeta skullMeta = (SkullMeta)item.getItemMeta();
                skullMeta.setOwner(this.skullOwner == null ? p.getName() : this.skullOwner);
                item.setItemMeta((ItemMeta)skullMeta);
            }
            if ((meta = item.getItemMeta()).hasDisplayName()) {
                meta.setDisplayName(NavBarItem.this.replacePlaceHolders(p, meta.getDisplayName(), type, page, allpages));
            }
            if (meta.hasLore()) {
                ArrayList<String> lore = new ArrayList<String>();
                for (String line : meta.getLore()) {
                    lore.add(NavBarItem.this.replacePlaceHolders(p, line, type, page, allpages));
                }
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
            return item;
        }
    }
}

