/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.providers;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.DiscordReadyEvent;
import github.scarsz.discordsrv.dependencies.jda.api.entities.EmbedType;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class DiscordSRVProvider {
    private final EconomyShopGUI plugin;
    private TextChannel transactionChannel;
    public boolean enabled;
    private String raw;
    private String title;
    private String description;
    private String authorTitle;
    private String authorImage;
    private String footerTitle;
    private String footerImage;
    private int color;

    public DiscordSRVProvider(EconomyShopGUI plugin) {
        this.plugin = plugin;
    }

    public DiscordSRVProvider(EconomyShopGUI plugin, ConfigurationSection section) {
        this.plugin = plugin;
        this.enabled = this.init(section);
    }

    public boolean init(ConfigurationSection section) {
        TextChannel channel = DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName(section.getString("channel"));
        if (channel != null) {
            this.transactionChannel = channel;
            if (section.contains("embed.color")) {
                this.color = this.getRGBColor();
            }
            if (section.contains("embed.title")) {
                this.title = section.getString("embed.title");
            }
            if (section.contains("embed.description")) {
                this.description = section.getString("embed.description");
            }
            if (section.contains("embed.author.title")) {
                this.authorTitle = section.getString("embed.author.title");
            }
            if (section.contains("embed.author.imageURL")) {
                this.authorImage = section.getString("embed.author.imageURL");
            }
            if (section.contains("embed.footer.title")) {
                this.footerTitle = section.getString("embed.footer.title");
            }
            if (section.contains("embed.footer.imageURL")) {
                this.footerImage = section.getString("embed.footer.imageURL");
            }
            if (section.contains("raw")) {
                this.raw = section.getString("raw");
            }
            SendMessage.infoMessage("Successfully enabled discordSRV hook, transactions will be logged to #" + this.transactionChannel);
            return true;
        }
        SendMessage.warnMessage("Failed to hook into DiscordSRV because no game channel with name '" + section.getString("channel") + "' was found inside the DiscordSRV config.");
        return false;
    }

    @Subscribe
    public void discordReadyEvent(DiscordReadyEvent event) {
        this.enabled = this.init(ConfigManager.getConfig().getConfigurationSection("discordsrv-transactions"));
    }

    private int getRGBColor() {
        String raw = ConfigManager.getConfig().getString("discordsrv-transactions.embed.color");
        if (!(raw = raw.replace("#", "")).startsWith("0x")) {
            raw = "0x" + raw;
        }
        try {
            return Color.decode(raw).getRGB();
        }
        catch (NumberFormatException e) {
            SendMessage.logDebugMessage(Lang.RGB_COLOR_FORMATTED_WRONG.get().replace("%path%", "discordsrv-transactions.embed.color"));
            SendMessage.errorItemConfig("discordsrv-transactions.embed.color");
            return 255;
        }
    }

    private String translateMessage(String message, Player player, int amount, String transactionMode, String items, String price) {
        return message.replace("%translations-discord-srv-transaction%", Lang.DISCORD_SRV_PLAYER_TRANSACTION.get()).replace("%player_name%", player.getName()).replace("%player_displayname%", ChatColor.stripColor((String)this.plugin.getDisplayName(player))).replace("%amount%", String.valueOf(amount)).replace("%bought/sold%", transactionMode).replace("%items%", ChatColor.stripColor((String)items)).replace("%price%", ChatColor.stripColor((String)price));
    }

    private List<MessageEmbed.Field> getFields(Player player, int amount, String transactionMode, String items, String price) {
        ArrayList<MessageEmbed.Field> fields = new ArrayList<MessageEmbed.Field>();
        for (String i : ConfigManager.getConfig().getConfigurationSection("discordsrv-transactions.embed.fields").getKeys(false)) {
            ConfigurationSection f = ConfigManager.getConfig().getConfigurationSection("discordsrv-transactions.embed.fields." + i);
            fields.add(new MessageEmbed.Field(f.getString("title"), this.translateMessage(f.getString("message"), player, amount, transactionMode, items, price), false));
        }
        return fields;
    }

    public void logTransaction(Player player, int amount, String transactionMode, String items, String price) {
        if (this.raw != null && !this.raw.isEmpty()) {
            this.transactionChannel.sendMessage((CharSequence)this.translateMessage(this.raw, player, amount, transactionMode, items, price)).queue();
        } else {
            this.transactionChannel.sendMessageEmbeds(new MessageEmbed(null, this.title, this.description != null && !this.description.isEmpty() ? this.translateMessage(this.description, player, amount, transactionMode, items, price) : null, EmbedType.RICH, null, this.color, null, null, this.authorTitle != null && !this.authorTitle.isEmpty() ? new MessageEmbed.AuthorInfo(this.authorTitle, null, this.getAuthorImage(player), null) : null, null, this.footerTitle != null && !this.footerTitle.isEmpty() ? new MessageEmbed.Footer(this.footerTitle, this.getFooterImage(player), null) : null, null, this.getFields(player, amount, transactionMode, items, price)), new MessageEmbed[0]).queue();
        }
    }

    private String getFooterImage(Player player) {
        return this.footerImage.replace("%player_name%", player.getName());
    }

    private String getAuthorImage(Player player) {
        return this.authorImage.replace("%player_name%", player.getName());
    }
}

