/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.providers.economys;

import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.providers.EconomyProvider;
import me.gypopo.economyshopgui.util.EcoType;
import me.gypopo.economyshopgui.util.EconomyType;
import me.gypopo.economyshopgui.util.exceptions.EconomyLoadException;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import su.nexmedia.engine.api.data.UserDataHolder;
import su.nightexpress.coinsengine.api.CoinsEngineAPI;
import su.nightexpress.coinsengine.api.currency.Currency;

public class CoinsEngineEconomy
implements EconomyProvider {
    private final String currency;
    private Currency cur;
    private String friendly;
    private String singular;
    private String plural;
    private boolean decimal;

    public CoinsEngineEconomy(String currency) {
        this.currency = currency;
    }

    @Override
    public void setup(EconomyShopGUI plugin) throws EconomyLoadException {
        if (!plugin.getServer().getPluginManager().isPluginEnabled("CoinsEngine")) {
            throw new EconomyLoadException("Could not find CoinsEngine");
        }
        this.registerCurrency();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerCurrency() throws EconomyLoadException {
        if (this.currency == null || this.currency.isEmpty()) {
            this.cur = CoinsEngineAPI.getCurrencyManager().getCurrencies().stream().findFirst().orElse(null);
            if (this.cur == null) throw new EconomyLoadException("Failed to find default currency from CoinsEngine");
            SendMessage.infoMessage("Successfully hooked into CoinsEngine and using default currency: " + this.cur.getName());
        } else {
            this.cur = CoinsEngineAPI.getCurrencyManager().getCurrency(this.currency);
            if (this.cur == null) throw new EconomyLoadException("Failed to register a CoinsEngine currency named as '" + this.currency + "'");
            SendMessage.infoMessage("Successfully registered currency '" + this.currency + "' from CoinsEngine");
        }
        this.formatSingular();
        this.formatPlural();
        this.formatFriendly();
        this.decimal = this.cur.isDecimal();
    }

    @Override
    public double getBalance(OfflinePlayer p) {
        return CoinsEngineAPI.getBalance((Player)((Player)p), (Currency)this.cur);
    }

    @Override
    public void depositBalance(OfflinePlayer p, double amount) {
        CoinsEngineAPI.getUserManager().getUserDataAsync(p.getUniqueId()).thenAccept(i -> {
            if (i == null) {
                SendMessage.errorMessage("Failed to withdraw balance: Cannot find player " + p.getName() + " in CoinsEngine");
            } else {
                i.getCurrencyData(this.cur).addBalance(amount);
                i.saveData((UserDataHolder)CoinsEngineAPI.PLUGIN);
            }
        });
    }

    @Override
    public void withdrawBalance(OfflinePlayer p, double amount) {
        CoinsEngineAPI.getUserManager().getUserDataAsync(p.getUniqueId()).thenAccept(i -> {
            if (i == null) {
                SendMessage.errorMessage("Failed to withdraw balance: Cannot find player " + p.getName() + " in CoinsEngine");
            } else {
                i.getCurrencyData(this.cur).removeBalance(amount);
                i.saveData((UserDataHolder)CoinsEngineAPI.PLUGIN);
            }
        });
    }

    @Override
    public EcoType getType() {
        return new EcoType(EconomyType.COINS_ENGINE, this.currency);
    }

    @Override
    public String getPlural() {
        return this.plural;
    }

    @Override
    public String getSingular() {
        return this.singular;
    }

    @Override
    public String getFriendly() {
        return this.friendly;
    }

    @Override
    public boolean isDecimal() {
        return this.decimal;
    }

    private void formatSingular() {
        String singular = ConfigManager.getConfig().getString("currency-formats.coins-engine:" + this.currency + ".singular", ConfigManager.getConfig().getString("currency-formats.coins-engine.singular", this.cur.getSymbol()));
        String format = this.cur.getFormat().replace("%amount%", "%price%").replace("%currency_symbol%", singular);
        this.singular = !singular.isEmpty() ? (this.isSymbol(singular) ? (format.isEmpty() ? Lang.SYMBOL_PRICING_FORMAT.get().replace("%symbol%", singular) : format) : (format.isEmpty() ? Lang.NAMED_PRICING_FORMAT.get().replace("%currency-format%", singular) : format)) : (format.isEmpty() ? Lang.SYMBOL_PRICING_FORMAT.get().replace("%symbol%", Lang.CURRENCYSYMBOL.get()) : format);
    }

    private void formatPlural() {
        String plural = ConfigManager.getConfig().getString("currency-formats.coins-engine:" + this.currency + ".plural", ConfigManager.getConfig().getString("currency-formats.coins-engine.plural", this.cur.getSymbol()));
        String format = this.cur.getFormat().replace("%amount%", "%price%").replace("%currency_symbol%", plural);
        this.plural = !plural.isEmpty() ? (this.isSymbol(plural) ? (format.isEmpty() ? Lang.SYMBOL_PRICING_FORMAT.get().replace("%symbol%", plural) : format) : (format.isEmpty() ? Lang.NAMED_PRICING_FORMAT.get().replace("%currency-format%", plural) : format)) : (format.isEmpty() ? Lang.SYMBOL_PRICING_FORMAT.get().replace("%symbol%", Lang.CURRENCYSYMBOL.get()) : format);
    }

    private void formatFriendly() {
        this.friendly = ConfigManager.getConfig().getString("currency-formats.ultra-economy:" + this.currency + ".friendly", ConfigManager.getConfig().getString("currency-formats.ultra-economy.friendly", this.cur.getName()));
    }

    private boolean isSymbol(String format) {
        return format.chars().count() == 1L;
    }
}

