/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.providers.economys;

import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.providers.EconomyProvider;
import me.gypopo.economyshopgui.util.EcoType;
import me.gypopo.economyshopgui.util.EconomyType;
import me.gypopo.economyshopgui.util.exceptions.EconomyLoadException;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class ExpEconomy
implements EconomyProvider {
    private String friendly;
    private String singular;
    private String plural;
    private final boolean decimal = false;

    @Override
    public void setup(EconomyShopGUI plugin) throws EconomyLoadException {
        this.formatSingular();
        this.formatPlural();
        this.friendly = ConfigManager.getConfig().getString("currency-formats.exp.friendly", Lang.XP_CURRENCY_NAME_PLURAL.get()).replace("%translations-exp-currency-name-plural%", Lang.XP_CURRENCY_NAME_PLURAL.get());
        SendMessage.infoMessage("Successfully enabled EXP points economy");
    }

    @Override
    public double getBalance(OfflinePlayer p) {
        return this.getTotalExperience((Player)p);
    }

    @Override
    public void depositBalance(OfflinePlayer p, double amount) {
        this.setTotalExperience((Player)p, this.getTotalExperience((Player)p) + (int)Math.round(amount));
    }

    @Override
    public void withdrawBalance(OfflinePlayer p, double amount) {
        this.setTotalExperience((Player)p, this.getTotalExperience((Player)p) - (int)Math.round(amount));
    }

    @Override
    public EcoType getType() {
        return new EcoType(EconomyType.EXP);
    }

    @Override
    public String getPlural() {
        return this.plural;
    }

    @Override
    public String getSingular() {
        return this.singular;
    }

    @Override
    public String getFriendly() {
        return this.friendly;
    }

    @Override
    public boolean isDecimal() {
        return this.decimal;
    }

    private void formatSingular() {
        String singular = ConfigManager.getConfig().getString("currency-formats.exp.singular", Lang.XP_CURRENCY_NAME_SINGULAR.get()).replace("%translations-exp-currency-name-singular%", Lang.XP_CURRENCY_NAME_SINGULAR.get());
        this.singular = !singular.isEmpty() ? (this.isSymbol(singular) ? Lang.SYMBOL_PRICING_FORMAT.get().replace("%symbol%", singular) : Lang.NAMED_PRICING_FORMAT.get().replace("%currency-format%", singular)) : Lang.CURRENCYSYMBOL.get();
    }

    private void formatPlural() {
        String plural = ConfigManager.getConfig().getString("currency-formats.exp.plural", Lang.XP_CURRENCY_NAME_PLURAL.get()).replace("%translations-exp-currency-name-plural%", Lang.XP_CURRENCY_NAME_PLURAL.get());
        this.plural = !plural.isEmpty() ? (this.isSymbol(plural) ? Lang.SYMBOL_PRICING_FORMAT.get().replace("%symbol%", plural) : Lang.NAMED_PRICING_FORMAT.get().replace("%currency-format%", plural)) : Lang.CURRENCYSYMBOL.get();
    }

    private boolean isSymbol(String format) {
        return format.chars().count() == 1L;
    }

    private void setTotalExperience(Player player, int exp) {
        player.setExp(0.0f);
        player.setLevel(0);
        player.setTotalExperience(0);
        int amount = exp;
        while (amount > 0) {
            int expToLevel = this.getExpAtLevel(player);
            if ((amount -= expToLevel) >= 0) {
                player.giveExp(expToLevel);
                continue;
            }
            player.giveExp(amount += expToLevel);
            amount = 0;
        }
    }

    private int getExpAtLevel(Player player) {
        return this.getExpAtLevel(player.getLevel());
    }

    private int getExpAtLevel(int level) {
        if (level <= 15) {
            return 2 * level + 7;
        }
        if (level >= 16 && level <= 30) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }

    private int getExpToLevel(int level) {
        int exp = 0;
        for (int currentLevel = 0; currentLevel < level; ++currentLevel) {
            exp += this.getExpAtLevel(currentLevel);
        }
        if (exp < 0) {
            exp = Integer.MAX_VALUE;
        }
        return exp;
    }

    private int getTotalExperience(Player player) {
        int exp = Math.round((float)this.getExpAtLevel(player) * player.getExp());
        int currentLevel = player.getLevel();
        while (currentLevel > 0) {
            exp += this.getExpAtLevel(--currentLevel);
        }
        if (exp < 0) {
            exp = Integer.MAX_VALUE;
        }
        return exp;
    }

    private int getExpUntilNextLevel(Player player) {
        int exp = Math.round((float)this.getExpAtLevel(player) * player.getExp());
        int nextLevel = player.getLevel();
        return this.getExpAtLevel(nextLevel) - exp;
    }
}

