/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.providers.economys;

import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.providers.EconomyProvider;
import me.gypopo.economyshopgui.util.EcoType;
import me.gypopo.economyshopgui.util.EconomyType;
import me.gypopo.economyshopgui.util.exceptions.EconomyLoadException;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultEconomy
implements EconomyProvider {
    private Economy economy;
    private String friendly;
    private String singular;
    private String plural;
    private boolean decimal;

    @Override
    public void setup(EconomyShopGUI plugin) throws EconomyLoadException {
        if (plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            throw new EconomyLoadException("Could not find Vault");
        }
        RegisteredServiceProvider rsp = plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            throw new EconomyLoadException("No supported economy provider for Vault detected, please install a plugin such as Essentials");
        }
        this.economy = (Economy)rsp.getProvider();
        this.formatSingular();
        this.formatPlural();
        this.decimal = this.economy.fractionalDigits() == -1 || this.economy.fractionalDigits() > 0;
        this.friendly = ConfigManager.getConfig().getString("currency-formats.vault.friendly", "money");
        SendMessage.infoMessage("Successfully hooked into Vault");
    }

    @Override
    public double getBalance(OfflinePlayer p) {
        return this.economy.getBalance(p);
    }

    @Override
    public void depositBalance(OfflinePlayer p, double amount) {
        this.economy.depositPlayer(p, amount);
    }

    @Override
    public void withdrawBalance(OfflinePlayer p, double amount) {
        this.economy.withdrawPlayer(p, amount);
    }

    @Override
    public EcoType getType() {
        return new EcoType(EconomyType.VAULT);
    }

    @Override
    public String getPlural() {
        return this.plural;
    }

    @Override
    public String getSingular() {
        return this.singular;
    }

    @Override
    public String getFriendly() {
        return this.friendly;
    }

    @Override
    public boolean isDecimal() {
        return this.decimal;
    }

    private void formatSingular() {
        String singular = ConfigManager.getConfig().getString("currency-formats.vault.singular", this.economy.currencyNameSingular());
        this.singular = !singular.isEmpty() ? (!singular.contains("%currency-symbol%") ? (this.isSymbol(singular) ? Lang.SYMBOL_PRICING_FORMAT.get().replace("%symbol%", singular) : Lang.NAMED_PRICING_FORMAT.get().replace("%currency-format%", singular)) : Lang.CURRENCYSYMBOL.get()) : Lang.CURRENCYSYMBOL.get();
    }

    private void formatPlural() {
        String plural = ConfigManager.getConfig().getString("currency-formats.vault.plural", this.economy.currencyNamePlural());
        this.plural = !plural.isEmpty() ? (!plural.contains("%currency-symbol%") ? (this.isSymbol(plural) ? Lang.SYMBOL_PRICING_FORMAT.get().replace("%symbol%", plural) : Lang.NAMED_PRICING_FORMAT.get().replace("%currency-format%", plural)) : Lang.CURRENCYSYMBOL.get()) : Lang.CURRENCYSYMBOL.get();
    }

    private boolean isSymbol(String format) {
        return format.chars().count() == 1L;
    }
}

