/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.providers.spawners;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.events.SpawnerBreakEvent;
import me.gypopo.economyshopgui.events.SpawnerInteractEvent;
import me.gypopo.economyshopgui.events.SpawnerPlaceEvent;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.providers.SpawnerProvider;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DefaultSpawnerProvider
implements SpawnerProvider {
    private final EconomyShopGUI plugin;
    private final boolean interact;

    public DefaultSpawnerProvider(EconomyShopGUI plugin, @Nullable SpawnerInteractEvent interactEvent, @Nullable SpawnerPlaceEvent placeEvent, @Nullable SpawnerBreakEvent breakEvent) {
        this.plugin = plugin;
        if (placeEvent != null) {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)placeEvent, (Plugin)this.plugin);
        }
        if (breakEvent != null) {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)breakEvent, (Plugin)this.plugin);
        }
        if (interactEvent != null) {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)interactEvent, (Plugin)this.plugin);
        }
        this.interact = interactEvent == null;
    }

    @Override
    public String getProviderName() {
        return "DEFAULT";
    }

    @Override
    public ItemStack setSpawnedType(@Nullable ShopItem shopItem, ItemStack item, EntityType type) {
        if (!this.interact) {
            item = this.plugin.versionHandler.setNBTInt(item, "HideFlags", 32);
        }
        if (shopItem == null) {
            item = this.plugin.versionHandler.setSpawnerType(item, type.name());
        }
        return item;
    }

    @Override
    public boolean isShopSpawner(ItemStack itemToMatch, ItemStack shopItem) {
        return this.plugin.isSimilar(itemToMatch, shopItem, new ArrayList<String>(Arrays.asList("display::Name")));
    }

    @Override
    public Double getSpawnerSellPrice(ItemStack itemToSearch, double baseSellPrice) {
        return baseSellPrice;
    }

    @Override
    public String getSpawnedType(ItemStack item) {
        return this.plugin.versionHandler.getSpawnerType(item);
    }
}

