/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.providers.spawners;

import de.dustplanet.util.SilkUtil;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.providers.SpawnerProvider;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class SilkSpawnersHook
implements SpawnerProvider {
    private SilkUtil su;

    public SilkSpawnersHook(SilkUtil silkUtil) {
        this.su = silkUtil;
    }

    @Override
    public String getProviderName() {
        return "SILKSPAWNERS";
    }

    @Override
    public ItemStack setSpawnedType(@Nullable ShopItem shopItem, ItemStack item, EntityType type) {
        String targetEntityType;
        if (shopItem != null) {
            return item;
        }
        String entityType = type.name();
        try {
            targetEntityType = (String)this.su.getDisplayNameToMobID().get(entityType);
        }
        catch (NullPointerException e) {
            targetEntityType = entityType;
        }
        if (targetEntityType == null) {
            targetEntityType = entityType;
        }
        return this.su.nmsProvider.setNBTEntityID(item, targetEntityType);
    }

    @Override
    public boolean isShopSpawner(ItemStack itemToMatch, ItemStack shopItem) {
        return EconomyShopGUI.getInstance().isSimilar(itemToMatch, shopItem, new ArrayList<String>(Arrays.asList("display::Name")));
    }

    @Override
    public Double getSpawnerSellPrice(ItemStack itemToSearch, double baseSellPrice) {
        return baseSellPrice;
    }

    @Override
    public String getSpawnedType(ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        BlockStateMeta blockStateMeta = (BlockStateMeta)itemMeta;
        CreatureSpawner creatureSpawner = (CreatureSpawner)blockStateMeta.getBlockState();
        return creatureSpawner.getSpawnedType().name();
    }
}

