/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.providers.spawners;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.providers.SpawnerProvider;
import org.bukkit.ChatColor;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class SilkSpawnersV2Hook
implements SpawnerProvider {
    private FileConfiguration ssConfig;
    private String itemName = ChatColor.LIGHT_PURPLE + "Spawner";
    private List<String> itemLore = new ArrayList<String>();
    private String prefix = ChatColor.YELLOW + "";
    private String oldPrefix = "";

    @Override
    public String getProviderName() {
        File conf = new File(EconomyShopGUI.getInstance().getDataFolder().getParent() + "/SilkSpawners_v2/config.yml");
        if (conf.exists()) {
            this.ssConfig = EconomyShopGUI.getInstance().loadConfiguration(new File(EconomyShopGUI.getInstance().getDataFolder().getParent() + "/SilkSpawners/config.yml"), "SilkSpawners config");
            this.loadValues();
        } else {
            SendMessage.warnMessage("Could not find the config.yml of SilkSpawnersV2, using default spawner prefix...");
        }
        return "SILKSPAWNERSV2";
    }

    private void loadValues() {
        this.itemName = ChatColor.translateAlternateColorCodes((char)'$', (String)this.ssConfig.getString("spawner.item.name"));
        this.itemLore = this.ssConfig.getStringList("spawner.item.lore").stream().map(s -> ChatColor.translateAlternateColorCodes((char)'$', (String)s)).collect(Collectors.toList());
        this.prefix = ChatColor.translateAlternateColorCodes((char)'$', (String)this.ssConfig.getString("spawner.item.prefix"));
        this.oldPrefix = ChatColor.translateAlternateColorCodes((char)'$', (String)this.ssConfig.getString("spawner.item.prefix-old"));
    }

    @Override
    public ItemStack setSpawnedType(@Nullable ShopItem shopItem, ItemStack item, EntityType type) {
        if (shopItem != null) {
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(this.itemName);
        List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
        lore.add(0, this.serializedName(type));
        lore.addAll(1, this.itemLore);
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private String serializedName(EntityType type) {
        return this.prefix + type.getName().substring(0, 1).toUpperCase() + type.getName().substring(1);
    }

    @Override
    public boolean isShopSpawner(ItemStack itemToMatch, ItemStack shopItem) {
        return this.getSpawnedType(itemToMatch).equals(this.getSpawnedType(shopItem)) && EconomyShopGUI.getInstance().isSimilar(itemToMatch, shopItem, new ArrayList<String>(Arrays.asList("display", "BlockEntityTag")));
    }

    @Override
    public Double getSpawnerSellPrice(ItemStack itemToSearch, double baseSellPrice) {
        return baseSellPrice;
    }

    @Override
    public String getSpawnedType(ItemStack item) {
        try {
            if (item.hasItemMeta() && item.getItemMeta().hasLore()) {
                String lore = (String)item.getItemMeta().getLore().get(0);
                if (lore.startsWith(this.prefix)) {
                    return EntityType.fromName((String)lore.replace(this.prefix, "").toLowerCase()).name();
                }
                if (!this.oldPrefix.equals("") && lore.startsWith(this.oldPrefix)) {
                    return EntityType.fromName((String)lore.replace(this.oldPrefix, "").toLowerCase()).name();
                }
            }
        }
        catch (NullPointerException lore) {
            // empty catch block
        }
        ItemMeta itemMeta = item.getItemMeta();
        BlockStateMeta blockStateMeta = (BlockStateMeta)itemMeta;
        CreatureSpawner creatureSpawner = (CreatureSpawner)blockStateMeta.getBlockState();
        return creatureSpawner.getSpawnedType().name();
    }
}

