/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.providers.spawners;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.providers.SpawnerProvider;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class UltimateStackerHook
implements SpawnerProvider {
    @Override
    public String getProviderName() {
        return "ULTIMATESTACKER";
    }

    @Override
    public ItemStack setSpawnedType(@Nullable ShopItem shopItem, ItemStack item, EntityType type) {
        if (shopItem != null) {
            return item;
        }
        ItemMeta itemMeta = item.getItemMeta();
        BlockStateMeta blockStateMeta = (BlockStateMeta)itemMeta;
        CreatureSpawner creatureSpawner = (CreatureSpawner)blockStateMeta.getBlockState();
        creatureSpawner.setSpawnedType(type);
        blockStateMeta.setBlockState((BlockState)creatureSpawner);
        item.setItemMeta(itemMeta);
        EconomyShopGUI.getInstance().versionHandler.setNBTInt(item, "spawner_stack_size", 1);
        return item;
    }

    @Override
    public boolean isShopSpawner(ItemStack itemToMatch, ItemStack shopItem) {
        return EconomyShopGUI.getInstance().isSimilar(itemToMatch, shopItem, new ArrayList<String>(Arrays.asList("spawner_stack_size", "display::Name")));
    }

    @Override
    public Double getSpawnerSellPrice(ItemStack itemToSearch, double baseSellPrice) {
        Integer amount = EconomyShopGUI.getInstance().versionHandler.getNBTInt(itemToSearch, "spawner_stack_size");
        amount = amount == null ? 1 : amount;
        return (double)amount.intValue() * baseSellPrice;
    }

    @Override
    public String getSpawnedType(ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        BlockStateMeta blockStateMeta = (BlockStateMeta)itemMeta;
        CreatureSpawner creatureSpawner = (CreatureSpawner)blockStateMeta.getBlockState();
        return creatureSpawner.getSpawnedType().name();
    }
}

