/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.providers.spawners;

import com.bgsoftware.wildstacker.api.WildStacker;
import com.bgsoftware.wildstacker.api.upgrades.SpawnerUpgrade;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.providers.SpawnerProvider;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class WildStackerHook
implements SpawnerProvider {
    private WildStacker ws;
    private FileConfiguration wsconfig;
    private List<SpawnerUpgrade> upgrades = new ArrayList<SpawnerUpgrade>();

    public WildStackerHook(WildStacker wildStacker) {
        this.ws = wildStacker;
        this.wsconfig = EconomyShopGUI.getInstance().loadConfiguration(new File(EconomyShopGUI.getInstance().getDataFolder().getParent() + "/WildStacker/config.yml"), "WildStacker config");
        if (!this.upgrades.isEmpty()) {
            this.upgrades.clear();
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (SpawnerUpgrade upgrade : this.ws.getUpgradesManager().getAllUpgrades()) {
            ids.add(upgrade.getId());
        }
        Collections.sort(ids);
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            this.upgrades.add(this.ws.getUpgradesManager().getUpgrade(id));
        }
    }

    @Override
    public String getProviderName() {
        return "WILDSTACKER";
    }

    @Override
    public ItemStack setSpawnedType(@Nullable ShopItem shopItem, ItemStack item, EntityType type) {
        if (shopItem != null) {
            return item;
        }
        ItemMeta itemMeta = item.getItemMeta();
        BlockStateMeta blockStateMeta = (BlockStateMeta)itemMeta;
        CreatureSpawner creatureSpawner = (CreatureSpawner)blockStateMeta.getBlockState();
        creatureSpawner.setSpawnedType(type);
        blockStateMeta.setBlockState((BlockState)creatureSpawner);
        item.setItemMeta(itemMeta);
        EconomyShopGUI.getInstance().versionHandler.setNBTInt(item, "spawners-amount", 1);
        return item;
    }

    @Override
    public boolean isShopSpawner(ItemStack itemToMatch, ItemStack shopItem) {
        return EconomyShopGUI.getInstance().isSimilar(itemToMatch, shopItem, new ArrayList<String>(Arrays.asList("spawners-amount", "spawners-upgrade", "display::Name")));
    }

    @Override
    public Double getSpawnerSellPrice(ItemStack itemToSearch, double baseSellPrice) {
        return this.getSellPrice(itemToSearch, baseSellPrice);
    }

    @Override
    public String getSpawnedType(ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        BlockStateMeta blockStateMeta = (BlockStateMeta)itemMeta;
        CreatureSpawner creatureSpawner = (CreatureSpawner)blockStateMeta.getBlockState();
        return creatureSpawner.getSpawnedType().name();
    }

    private Double getSellPrice(ItemStack spawner, double baseSellPrice) {
        Integer amount = EconomyShopGUI.getInstance().versionHandler.getNBTInt(spawner, "spawners-amount");
        amount = amount == null ? 1 : amount;
        boolean multiplyCost = this.wsconfig.getBoolean("spawners.spawner-upgrades.multiply-stack-amount", true);
        Integer upgradeID = EconomyShopGUI.getInstance().versionHandler.getNBTInt(spawner, "spawners-upgrade");
        upgradeID = upgradeID == null || upgradeID == -1 ? 0 : upgradeID;
        double upgradeCost = this.getTotalUpgradeCost(upgradeID);
        return multiplyCost ? (double)amount.intValue() * upgradeCost + (double)amount.intValue() * baseSellPrice : upgradeCost + (double)amount.intValue() * baseSellPrice;
    }

    private double getTotalUpgradeCost(Integer upgradeID) {
        if (upgradeID == null || upgradeID == 0) {
            return 0.0;
        }
        double cost = 0.0;
        for (SpawnerUpgrade upgrade : this.upgrades) {
            cost += upgrade.getCost();
            if (upgrade.getId() != upgradeID.intValue()) continue;
            break;
        }
        return cost;
    }
}

