/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.util;

import java.util.HashMap;
import java.util.Map;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.providers.EconomyProvider;
import me.gypopo.economyshopgui.providers.economys.CoinsEngineEconomy;
import me.gypopo.economyshopgui.providers.economys.ExpEconomy;
import me.gypopo.economyshopgui.providers.economys.GemsEconomy;
import me.gypopo.economyshopgui.providers.economys.PlayerPointsEconomy;
import me.gypopo.economyshopgui.providers.economys.UltraEconomy;
import me.gypopo.economyshopgui.providers.economys.VaultEconomy;
import me.gypopo.economyshopgui.util.EcoType;
import me.gypopo.economyshopgui.util.EconomyType;
import me.gypopo.economyshopgui.util.exceptions.EconomyLoadException;

public class EconomyHandler {
    private final EconomyShopGUI plugin;
    private EconomyProvider defaultProvider;
    private Map<String, EconomyProvider> shopPaymentTypes = new HashMap<String, EconomyProvider>();
    private Map<EcoType, EconomyProvider> registeredPaymentOptions = new HashMap<EcoType, EconomyProvider>();

    public EconomyHandler(EconomyShopGUI plugin) {
        this.plugin = plugin;
    }

    public boolean registerPaymentSolutions() {
        if (this.loadDefaultEconomy() == null) {
            return false;
        }
        int i = 0;
        for (String section : this.plugin.getShopSections()) {
            EcoType economyType = this.getEconomyType(section);
            if (economyType != null) {
                EconomyProvider provider = this.registeredPaymentOptions.get(economyType);
                if (provider == null) {
                    try {
                        this.shopPaymentTypes.put(section, this.initProvider(economyType));
                        SendMessage.logDebugMessage(Lang.SECTION_ECONOMY_PROVIDER_LOADED.get().replace("%economy%", economyType.toString()).replace("%shop%", section));
                    }
                    catch (EconomyLoadException e) {
                        SendMessage.errorMessage(Lang.CANNOT_LOAD_ECONOMY_PROVIDER.get().replace("%shop%", section).replace("%reason%", e.getMessage()));
                    }
                } else {
                    this.shopPaymentTypes.put(section, provider);
                    SendMessage.logDebugMessage(Lang.SECTION_ECONOMY_PROVIDER_LOADED.get().replace("%economy%", economyType.toString()).replace("%shop%", section));
                }
            }
            ++i;
        }
        SendMessage.infoMessage(Lang.ECONOMY_PROVIDERS_LOADED.get().replace("%total%", String.valueOf(this.registeredPaymentOptions.size())).replace("%shops%", String.valueOf(i)));
        return true;
    }

    private EcoType getEconomyType(String section) {
        String type = ConfigManager.getSection(section).getString("economy");
        if (type == null) {
            return null;
        }
        EcoType economyType = EconomyType.getFromString(type);
        if (economyType == null) {
            SendMessage.warnMessage(Lang.CANNOT_FIND_ECONOMY_PROVIDER.get().replace("%shop%", section).replace("%type%", type));
            return null;
        }
        return economyType;
    }

    private EconomyProvider loadDefaultEconomy() {
        EcoType economyType = EconomyType.getFromString(ConfigManager.getConfig().getString("economy-provider"));
        if (economyType == null) {
            SendMessage.warnMessage(Lang.CANNOT_FIND_DEFAULT_ECONOMY_PROVIDER.get().replace("%economy%", ConfigManager.getConfig().getString("economy-provider")));
            this.defaultProvider = this.getAvailableEcon();
            return this.defaultProvider != null ? this.defaultProvider : null;
        }
        try {
            this.defaultProvider = this.initProvider(economyType);
        }
        catch (EconomyLoadException e) {
            SendMessage.warnMessage(Lang.CANNOT_LOAD_DEFAULT_ECONOMY_PROVIDER.get().replace("%reason%", e.getMessage()));
            this.defaultProvider = this.getAvailableEcon();
            return this.defaultProvider != null ? this.defaultProvider : null;
        }
        return this.defaultProvider;
    }

    private EconomyProvider initProvider(EcoType type) throws EconomyLoadException {
        EconomyProvider provider = this.getProvider(type);
        provider.setup(this.plugin);
        this.registeredPaymentOptions.put(type, provider);
        return provider;
    }

    private EconomyProvider getProvider(EcoType type) {
        if (type == null) {
            return null;
        }
        switch (type.getType()) {
            case PLAYER_POINTS: {
                return new PlayerPointsEconomy();
            }
            case VAULT: {
                return new VaultEconomy();
            }
            case COINS_ENGINE: {
                return type.getCurrency() != null ? new CoinsEngineEconomy(type.getCurrency()) : new CoinsEngineEconomy(null);
            }
            case GEMS_ECONOMY: {
                return type.getCurrency() != null ? new GemsEconomy(type.getCurrency()) : new GemsEconomy(null);
            }
            case ULTRA_ECONOMY: {
                return type.getCurrency() != null ? new UltraEconomy(type.getCurrency()) : new UltraEconomy(null);
            }
            case EXP: {
                return new ExpEconomy();
            }
        }
        return null;
    }

    private EconomyProvider getAvailableEcon() {
        EconomyProvider provider = null;
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("Vault")) {
            SendMessage.infoMessage("Detected Vault, initializing...");
            provider = new VaultEconomy();
        } else if (this.plugin.getServer().getPluginManager().isPluginEnabled("UltraEconomy")) {
            SendMessage.infoMessage("Detected UltraEconomy, initializing...");
            provider = new UltraEconomy(null);
        } else if (this.plugin.getServer().getPluginManager().isPluginEnabled("CoinsEngine")) {
            SendMessage.infoMessage("Detected CoinsEngine, initializing...");
            provider = new CoinsEngineEconomy(null);
        } else if (this.plugin.getServer().getPluginManager().isPluginEnabled("GemsEconomy")) {
            SendMessage.infoMessage("Detected GemsEconomy, initializing...");
            provider = new GemsEconomy(null);
        } else if (this.plugin.getServer().getPluginManager().isPluginEnabled("PlayerPoints")) {
            SendMessage.infoMessage("Detected PlayerPoints, initializing...");
            provider = new PlayerPointsEconomy();
        }
        if (provider != null) {
            try {
                provider.setup(this.plugin);
                this.registeredPaymentOptions.put(provider.getType(), provider);
                return provider;
            }
            catch (EconomyLoadException economyLoadException) {
                // empty catch block
            }
        }
        SendMessage.warnMessage("===================================================");
        SendMessage.warnMessage(" ");
        SendMessage.warnMessage("Failed to automatically load an available economy provider, this plugin requires one, disabling...");
        SendMessage.warnMessage("See a list of available economy providers on our wiki here: https://wiki.gpplugins.com/economyshopgui/file-configuration/config.yml#economy-provider");
        SendMessage.warnMessage(" ");
        SendMessage.warnMessage("===================================================");
        return null;
    }

    public boolean relead() {
        if (this.shopPaymentTypes.size() > 0) {
            this.shopPaymentTypes.clear();
        }
        if (this.registeredPaymentOptions.size() > 0) {
            this.registeredPaymentOptions.clear();
        }
        this.defaultProvider = null;
        return this.registerPaymentSolutions();
    }

    public EconomyProvider getEcon(String section) {
        return this.shopPaymentTypes.containsKey(section) ? this.shopPaymentTypes.get(section) : this.defaultProvider;
    }

    public EconomyProvider getEcon(EcoType type) {
        if (type == null) {
            return this.defaultProvider;
        }
        return this.registeredPaymentOptions.get(type);
    }

    public EconomyProvider getDefaultProvider() {
        return this.defaultProvider;
    }
}

