/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.util;

import me.gypopo.economyshopgui.files.Lang;

public class Transaction {

    public static enum Result {
        SUCCESS,
        SUCCESS_COMMANDS_EXECUTED,
        NOT_ALL_ITEMS_ADDED,
        NOT_ENOUGH_SPACE,
        INSUFFICIENT_FUNDS,
        NO_INVENTORY_SPACE,
        NEGATIVE_ITEM_PRICE,
        TRANSACTION_CANCELLED,
        NO_ITEMS_FOUND,
        NO_ITEM_STOCK_LEFT,
        HIGHER_LEVEL_REQUIRED,
        REACHED_SELL_LIMIT;

    }

    public static enum Type {
        SELL_GUI_SCREEN(Lang.SELLGUI_SCREEN.get()),
        SELL_ALL_COMMAND(Lang.SELLALL_COMMAND.get()),
        SELL_ALL_SCREEN(Lang.SELLALL_SCREEN.get()),
        SELL_SCREEN(Lang.SELL_SCREEN.get()),
        BUY_SCREEN(Lang.BUY_SCREEN.get()),
        BUY_STACKS_SCREEN(Lang.BUYSTACKS_SCREEN.get()),
        QUICK_SELL(Lang.QUICK_SELL.get()),
        QUICK_BUY(Lang.QUICK_BUY.get()),
        AUTO_SELL_CHEST(Lang.AUTO_SELL_CHEST.get());

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getMode() {
            return Mode.getFromType(this).getName();
        }
    }

    public static enum Mode {
        BUY(Lang.BOUGHT.get()),
        SELL(Lang.SOLD.get());

        private String name;

        private Mode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Mode getFromType(Type type) {
            return type == Type.BUY_SCREEN || type == Type.BUY_STACKS_SCREEN ? BUY : SELL;
        }
    }
}

