/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.citizenscmd.commands;

import me.mattstudios.citizenscmd.CitizensCMD;
import me.mattstudios.citizenscmd.mf.annotations.Command;
import me.mattstudios.citizenscmd.mf.annotations.Completion;
import me.mattstudios.citizenscmd.mf.annotations.Permission;
import me.mattstudios.citizenscmd.mf.annotations.SubCommand;
import me.mattstudios.citizenscmd.mf.base.CommandBase;
import me.mattstudios.citizenscmd.utility.MessageUtils;
import me.mattstudios.citizenscmd.utility.Messages;
import me.mattstudios.citizenscmd.utility.NumbersUtils;
import me.mattstudios.citizenscmd.utility.Util;
import org.bukkit.entity.Player;

@Command(value="npcmd")
public class AddCommand
extends CommandBase {
    private CitizensCMD plugin;

    public AddCommand(CitizensCMD plugin) {
        this.plugin = plugin;
    }

    @SubCommand(value="add")
    @Permission(value="citizenscmd.add")
    public void addCommand(Player player, @Completion(value={"#permissions"}) String permission, String[] arguments) {
        if (Util.npcNotSelected(this.plugin, player)) {
            return;
        }
        StringBuilder permissionBuilder = new StringBuilder(permission);
        boolean left = false;
        boolean displayName = false;
        boolean hasDelayError = false;
        StringBuilder stringBuilder = new StringBuilder();
        arguments[0] = arguments[0].replace("/", "");
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i].equalsIgnoreCase("")) continue;
            if (arguments[i].equalsIgnoreCase("-n")) {
                displayName = true;
                continue;
            }
            if (arguments[i].equalsIgnoreCase("-l")) {
                left = true;
                continue;
            }
            if (arguments[i].equalsIgnoreCase("-d")) {
                if (i + 1 >= arguments.length) {
                    hasDelayError = true;
                    continue;
                }
                if (!NumbersUtils.isDouble(arguments[i + 1])) {
                    hasDelayError = true;
                    continue;
                }
                permissionBuilder.append("(").append(arguments[i + 1]).append(")");
                arguments[i + 1] = "";
                continue;
            }
            if (i == arguments.length - 1) {
                stringBuilder.append(arguments[i]);
                continue;
            }
            stringBuilder.append(arguments[i]).append(" ");
        }
        if (hasDelayError) {
            player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
            player.sendMessage(this.plugin.getLang().getMessage(Messages.NPC_ADD_DELAY_FAIL));
            return;
        }
        String finalString = displayName ? "{display} " + stringBuilder.toString().trim() : stringBuilder.toString().trim();
        if (permissionBuilder.toString().equalsIgnoreCase("sound")) {
            if (arguments.length < 2) {
                finalString = finalString + " 1 1";
            } else if (arguments.length < 3) {
                finalString = finalString + " 1";
            }
        }
        this.plugin.getDataHandler().addCommand(Util.getSelectedNpcId(player), permissionBuilder.toString(), finalString, player, left);
    }
}

