/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.citizenscmd.commands;

import me.mattstudios.citizenscmd.CitizensCMD;
import me.mattstudios.citizenscmd.mf.annotations.Command;
import me.mattstudios.citizenscmd.mf.annotations.Completion;
import me.mattstudios.citizenscmd.mf.annotations.Permission;
import me.mattstudios.citizenscmd.mf.annotations.SubCommand;
import me.mattstudios.citizenscmd.mf.base.CommandBase;
import me.mattstudios.citizenscmd.utility.EnumTypes;
import me.mattstudios.citizenscmd.utility.MessageUtils;
import me.mattstudios.citizenscmd.utility.Messages;
import me.mattstudios.citizenscmd.utility.Util;
import org.bukkit.entity.Player;

@Command(value="npcmd")
public class EditCommand
extends CommandBase {
    private CitizensCMD plugin;

    public EditCommand(CitizensCMD plugin) {
        this.plugin = plugin;
    }

    @SubCommand(value="edit")
    @Permission(value="citizenscmd.edit")
    @Completion(value={"#type", "#click"})
    public void edit(Player player, String typeString, String clickString, int id, String[] arguments) {
        EnumTypes.ClickType click;
        EnumTypes.EditType type;
        if (Util.npcNotSelected(this.plugin, player)) {
            return;
        }
        int npc = Util.getSelectedNpcId(player);
        switch (typeString.toLowerCase()) {
            case "cmd": {
                type = EnumTypes.EditType.CMD;
                break;
            }
            case "perm": {
                if (arguments.length > 1) {
                    player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                    player.sendMessage(this.plugin.getLang().getMessage(Messages.INVALID_PERMISSION));
                    return;
                }
                type = EnumTypes.EditType.PERM;
                break;
            }
            default: {
                player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                player.sendMessage(this.plugin.getLang().getMessage(Messages.INVALID_ARGUMENTS));
                return;
            }
        }
        switch (clickString.toLowerCase()) {
            case "left": {
                int leftCommandSize = this.plugin.getDataHandler().getClickCommandsData(npc, EnumTypes.ClickType.LEFT).size();
                if (leftCommandSize == 0) {
                    player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                    player.sendMessage(this.plugin.getLang().getMessage(Messages.NO_COMMANDS));
                    return;
                }
                if (id < 1 || id > leftCommandSize) {
                    player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                    player.sendMessage(this.plugin.getLang().getMessage(Messages.INVALID_ID_NUMBER));
                    return;
                }
                click = EnumTypes.ClickType.LEFT;
                break;
            }
            case "right": {
                int rightCommandSize = this.plugin.getDataHandler().getClickCommandsData(npc, EnumTypes.ClickType.RIGHT).size();
                if (rightCommandSize == 0) {
                    player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                    player.sendMessage(this.plugin.getLang().getMessage(Messages.NO_COMMANDS));
                    return;
                }
                if (id < 1 || id > rightCommandSize) {
                    player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                    player.sendMessage(this.plugin.getLang().getMessage(Messages.INVALID_ID_NUMBER));
                    return;
                }
                click = EnumTypes.ClickType.RIGHT;
                break;
            }
            default: {
                player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
                player.sendMessage(this.plugin.getLang().getMessage(Messages.INVALID_CLICK_TYPE));
                return;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        arguments[0] = arguments[0].replace("/", "");
        for (int i = 0; i < arguments.length; ++i) {
            if (i == arguments.length - 1) {
                stringBuilder.append(arguments[i]);
                continue;
            }
            stringBuilder.append(arguments[i]).append(" ");
        }
        this.plugin.getDataHandler().edit(npc, id, click, type, stringBuilder.toString().trim(), player);
    }
}

