/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.citizenscmd.commands;

import java.util.ArrayList;
import me.mattstudios.citizenscmd.CitizensCMD;
import me.mattstudios.citizenscmd.mf.annotations.Command;
import me.mattstudios.citizenscmd.mf.annotations.Permission;
import me.mattstudios.citizenscmd.mf.annotations.SubCommand;
import me.mattstudios.citizenscmd.mf.base.CommandBase;
import me.mattstudios.citizenscmd.utility.EnumTypes;
import me.mattstudios.citizenscmd.utility.MessageUtils;
import me.mattstudios.citizenscmd.utility.Messages;
import me.mattstudios.citizenscmd.utility.Util;
import me.rayzr522.jsonmessage.JSONMessage;
import org.bukkit.entity.Player;

@Command(value="npcmd")
public class ListCommand
extends CommandBase {
    private CitizensCMD plugin;

    public ListCommand(CitizensCMD plugin) {
        this.plugin = plugin;
    }

    @SubCommand(value="list")
    @Permission(value="citizenscmd.list")
    public void list(Player player) {
        if (Util.npcNotSelected(this.plugin, player)) {
            return;
        }
        int npc = Util.getSelectedNpcId(player);
        ArrayList leftCommands = this.plugin.getDataHandler().getClickCommandsData(npc, EnumTypes.ClickType.LEFT) != null ? this.plugin.getDataHandler().getClickCommandsData(npc, EnumTypes.ClickType.LEFT) : new ArrayList();
        ArrayList rightCommands = this.plugin.getDataHandler().getClickCommandsData(npc, EnumTypes.ClickType.RIGHT) != null ? this.plugin.getDataHandler().getClickCommandsData(npc, EnumTypes.ClickType.RIGHT) : new ArrayList();
        player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
        JSONMessage.create(MessageUtils.color(this.plugin.getLang().getUncoloredMessage(Messages.LIST_COOLDOWN) + this.plugin.getDataHandler().getNPCCooldown(npc))).tooltip(this.plugin.getLang().getMessage(Messages.LIST_TOOLTIP)).suggestCommand("/npcmd cooldown ").send(player);
        JSONMessage.create(MessageUtils.color(this.plugin.getLang().getUncoloredMessage(Messages.LIST_PRICE) + this.plugin.getDataHandler().getPrice(npc))).tooltip(this.plugin.getLang().getMessage(Messages.LIST_TOOLTIP)).suggestCommand("/npcmd price ").send(player);
        player.sendMessage("");
        player.sendMessage(this.plugin.getLang().getMessage(Messages.LIST_COUNT_RIGHT).replace("{count}", String.valueOf(rightCommands.size())));
        int rightCount = 1;
        for (String command : rightCommands) {
            JSONMessage.create(MessageUtils.color("&c" + rightCount + " &7- &7" + command.replace("[", "&8[&c").replace("]", "&8]&b"))).suggestCommand("/npcmd edit cmd right " + rightCount + " ").tooltip(this.plugin.getLang().getMessage(Messages.LIST_TOOLTIP)).send(player);
            ++rightCount;
        }
        player.sendMessage("");
        player.sendMessage(this.plugin.getLang().getMessage(Messages.LIST_COUNT_LEFT).replace("{count}", String.valueOf(leftCommands.size())));
        int leftCount = 1;
        for (String command : leftCommands) {
            JSONMessage.create(MessageUtils.color("&c" + leftCount + " &7- &7" + command.replace("[", "&8[&c").replace("]", "&8]&b"))).suggestCommand("/npcmd edit cmd left " + leftCount + " ").tooltip(this.plugin.getLang().getMessage(Messages.LIST_TOOLTIP)).send(player);
            ++leftCount;
        }
    }
}

