/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.citizenscmd.commands;

import java.util.Objects;
import me.mattstudios.citizenscmd.CitizensCMD;
import me.mattstudios.citizenscmd.mf.annotations.Command;
import me.mattstudios.citizenscmd.mf.annotations.Permission;
import me.mattstudios.citizenscmd.mf.annotations.SubCommand;
import me.mattstudios.citizenscmd.mf.base.CommandBase;
import me.mattstudios.citizenscmd.utility.DisplayFormat;
import me.mattstudios.citizenscmd.utility.MessageUtils;
import me.mattstudios.citizenscmd.utility.Messages;
import org.bukkit.command.CommandSender;

@Command(value="npcmd")
public class ReloadCommand
extends CommandBase {
    private CitizensCMD plugin;

    public ReloadCommand(CitizensCMD plugin) {
        this.plugin = plugin;
    }

    @SubCommand(value="reload")
    @Permission(value="citizenscmd.reload")
    public void reload(CommandSender player) {
        this.plugin.reloadConfig();
        this.plugin.saveDefaultConfig();
        this.plugin.setLang(Objects.requireNonNull(this.plugin.getConfig().getString("lang")));
        if (this.plugin.getConfig().contains("cooldown-time-display")) {
            switch (Objects.requireNonNull(this.plugin.getConfig().getString("cooldown-time-display")).toLowerCase()) {
                case "short": {
                    this.plugin.setDisplayFormat(DisplayFormat.SHORT);
                    break;
                }
                case "full": {
                    this.plugin.setDisplayFormat(DisplayFormat.FULL);
                    break;
                }
                default: {
                    this.plugin.setDisplayFormat(DisplayFormat.MEDIUM);
                    break;
                }
            }
        } else {
            this.plugin.setDisplayFormat(DisplayFormat.MEDIUM);
        }
        if (CitizensCMD.getEconomy() != null) {
            this.plugin.setShift(this.plugin.getConfig().getBoolean("shift-confirm"));
        }
        this.plugin.getDataHandler().reload();
        this.plugin.getCooldownHandler().reload();
        player.sendMessage(MessageUtils.color("&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-"));
        player.sendMessage(this.plugin.getLang().getMessage(Messages.RELOAD));
    }
}

