/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.citizenscmd.files;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import me.mattstudios.citizenscmd.CitizensCMD;
import me.mattstudios.citizenscmd.utility.MessageUtils;
import me.mattstudios.citizenscmd.utility.Util;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class CooldownHandler {
    private CitizensCMD plugin;
    private File cooldownsFile;
    private File dir;
    private FileConfiguration cooldownsConfigurator;
    private HashMap<String, Long> cooldownData;

    public CooldownHandler(CitizensCMD plugin) {
        this.plugin = plugin;
    }

    public void initialize() {
        File pluginFolder = this.plugin.getDataFolder();
        this.dir = new File(pluginFolder + "/data");
        this.cooldownsFile = new File(this.dir.getPath(), "cooldowns.yml");
        this.cooldownsConfigurator = new YamlConfiguration();
        this.cooldownData = new HashMap();
        this.createBasics();
        this.cacheData();
    }

    private void createBasics() {
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        if (!this.cooldownsFile.exists()) {
            try {
                this.cooldownsFile.createNewFile();
            }
            catch (IOException e) {
                MessageUtils.info(MessageUtils.color("&cError creating cooldowns file.."));
            }
        }
    }

    private void cacheData() {
        try {
            this.cooldownsConfigurator.load(this.cooldownsFile);
            if (!this.cooldownsConfigurator.contains("cooldown-data")) {
                return;
            }
            HashMap<String, Integer> cachedDataFromSaves = this.plugin.getDataHandler().getCachedCooldownByID();
            for (String parent : Objects.requireNonNull(this.cooldownsConfigurator.getConfigurationSection("cooldown-data")).getKeys(false)) {
                for (String child : Objects.requireNonNull(this.cooldownsConfigurator.getConfigurationSection("cooldown-data." + parent)).getKeys(false)) {
                    for (String npc : cachedDataFromSaves.keySet()) {
                        if (!npc.equalsIgnoreCase(parent) || Util.getSecondsDifference(this.cooldownsConfigurator.getLong("cooldown-data." + parent + "." + child)) >= (long)cachedDataFromSaves.get(npc).intValue() && cachedDataFromSaves.get(npc) != -1) continue;
                        this.cooldownData.put("cooldown-data." + parent + "." + child, this.cooldownsConfigurator.getLong("cooldown-data." + parent + "." + child));
                    }
                }
            }
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void saveToFile() {
        try {
            this.createBasics();
            this.cooldownsConfigurator.load(this.cooldownsFile);
            this.cooldownsConfigurator.set("cooldown-data", null);
            for (String path : this.cooldownData.keySet()) {
                this.cooldownsConfigurator.set(path, (Object)this.cooldownData.get(path));
            }
            this.cooldownsConfigurator.save(this.cooldownsFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void addInteraction(int npc, String uuid, long time) {
        if (this.cooldownData.containsKey("cooldown-data.npc-" + npc + "." + uuid)) {
            this.cooldownData.replace("cooldown-data.npc-" + npc + "." + uuid, time);
        } else {
            this.cooldownData.put("cooldown-data.npc-" + npc + "." + uuid, time);
        }
    }

    public long getTimeLeft(int npc, String uuid) {
        return (long)this.plugin.getDataHandler().getNPCCooldown(npc) - Util.getSecondsDifference(this.cooldownData.get("cooldown-data.npc-" + npc + "." + uuid));
    }

    public boolean onCooldown(int npc, String uuid) {
        if (this.cooldownData.containsKey("cooldown-data.npc-" + npc + "." + uuid)) {
            if (this.plugin.getDataHandler().getNPCCooldown(npc) == -1) {
                return true;
            }
            return Util.getSecondsDifference(this.cooldownData.get("cooldown-data.npc-" + npc + "." + uuid)) < (long)this.plugin.getDataHandler().getNPCCooldown(npc);
        }
        return false;
    }

    public void reload() {
        this.saveToFile();
    }
}

