/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.citizenscmd.files;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Objects;
import java.util.Random;
import me.mattstudios.citizenscmd.CitizensCMD;
import me.mattstudios.citizenscmd.commons.FileUtils;
import me.mattstudios.citizenscmd.utility.MessageUtils;
import me.mattstudios.citizenscmd.utility.Messages;
import org.bukkit.configuration.file.YamlConfiguration;
import org.simpleyaml.configuration.file.YamlFile;
import org.simpleyaml.exceptions.InvalidConfigurationException;

public class LangHandler {
    private CitizensCMD plugin;
    private String lang;
    private HashMap<String, String> messages;

    public LangHandler(CitizensCMD plugin, String lang) {
        this.plugin = plugin;
        this.lang = lang;
        this.messages = new HashMap();
        this.cacheMessage();
    }

    private void cacheMessage() {
        try {
            File langFile = new File(this.plugin.getDataFolder(), "lang/" + this.lang + ".yml");
            YamlConfiguration langConf = new YamlConfiguration();
            InputStream langStream = CitizensCMD.class.getClassLoader().getResourceAsStream("lang/" + this.lang + ".yml");
            if (!langFile.exists()) {
                if (langStream == null) {
                    langFile.createNewFile();
                    LangHandler.saveDefaults(CitizensCMD.class.getClassLoader().getResourceAsStream("lang/en.yml"), langFile);
                } else {
                    this.plugin.saveResource("lang/" + this.lang + ".yml", false);
                }
            } else if (langStream == null) {
                LangHandler.saveDefaults(CitizensCMD.class.getClassLoader().getResourceAsStream("lang/en.yml"), langFile);
            } else {
                LangHandler.saveDefaults(langStream, langFile);
            }
            langConf.load(langFile);
            for (String parent : Objects.requireNonNull(langConf.getConfigurationSection("messages")).getKeys(false)) {
                for (String child : Objects.requireNonNull(langConf.getConfigurationSection("messages." + parent)).getKeys(false)) {
                    this.messages.put("messages." + parent + "." + child, langConf.getString("messages." + parent + "." + child));
                }
            }
        }
        catch (IOException | org.bukkit.configuration.InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public String getMessage(Messages path) {
        return MessageUtils.color(this.messages.get(path.getPath()));
    }

    public String getUncoloredMessage(Messages path) {
        return this.messages.get(path.getPath());
    }

    public String getLanguage() {
        return this.lang;
    }

    private static void saveDefaults(InputStream inputFile, File outputFile) {
        try {
            if (inputFile == null) {
                return;
            }
            File tempFile = File.createTempFile("npcmdCfg" + LangHandler.gen(), "yml");
            FileUtils.copyInputStreamToFile(inputFile, tempFile);
            inputFile.close();
            YamlFile resourceYaml = new YamlFile(tempFile);
            YamlFile savedYaml = new YamlFile(outputFile);
            resourceYaml.load();
            savedYaml.load();
            boolean edited = false;
            for (String parent : resourceYaml.getConfigurationSection("messages").getKeys(false)) {
                for (String child : resourceYaml.getConfigurationSection("messages." + parent).getKeys(false)) {
                    String key = "messages." + parent + "." + child;
                    if (!savedYaml.contains(key)) continue;
                    edited = true;
                    resourceYaml.set(key, savedYaml.get(key));
                }
            }
            if (edited) {
                resourceYaml.saveWithComments();
            }
            FileUtils.copyFile(tempFile, outputFile);
            tempFile.delete();
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    private static int gen() {
        Random r = new Random(System.currentTimeMillis());
        return 10000 + r.nextInt(20000);
    }
}

