/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.citizenscmd.mf.base;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import me.mattstudios.citizenscmd.mf.annotations.Alias;
import me.mattstudios.citizenscmd.mf.base.CommandBase;
import me.mattstudios.citizenscmd.mf.base.CommandHandler;
import me.mattstudios.citizenscmd.mf.base.CompletionHandler;
import me.mattstudios.citizenscmd.mf.base.MessageHandler;
import me.mattstudios.citizenscmd.mf.base.ParameterHandler;
import me.mattstudios.citizenscmd.mf.exceptions.NoCommandException;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandManager
implements Listener {
    private JavaPlugin plugin;
    private Map<String, CommandHandler> commands;
    private ParameterHandler parameterHandler;
    private CompletionHandler completionHandler;
    private MessageHandler messageHandler;

    public CommandManager(JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.commands = new HashMap<String, CommandHandler>();
        this.completionHandler = new CompletionHandler();
        this.messageHandler = new MessageHandler();
        this.parameterHandler = new ParameterHandler(this.messageHandler);
    }

    public ParameterHandler getParameterHandler() {
        return this.parameterHandler;
    }

    public CompletionHandler getCompletionHandler() {
        return this.completionHandler;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void register(CommandBase command) {
        Class<?> commandClass = command.getClass();
        if (!commandClass.isAnnotationPresent(me.mattstudios.citizenscmd.mf.annotations.Command.class)) {
            throw new NoCommandException("Class " + command.getClass().getName() + " needs to have @Command!");
        }
        String commandName = commandClass.getAnnotation(me.mattstudios.citizenscmd.mf.annotations.Command.class).value();
        String[] aliases = new String[]{};
        if (commandClass.isAnnotationPresent(Alias.class)) {
            aliases = commandClass.getAnnotation(Alias.class).value();
        }
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            if (this.commands.containsKey(commandName)) {
                this.commands.get(commandName).addSubCommands(command, commandName);
                return;
            }
            CommandHandler commandHandler = new CommandHandler(this.parameterHandler, this.completionHandler, this.messageHandler, command, commandName, Arrays.asList(aliases));
            commandMap.register(this.plugin.getName(), (Command)commandHandler);
            this.commands.put(commandName, commandHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        if (!this.plugin.getName().equalsIgnoreCase(event.getPlugin().getName())) {
            return;
        }
        this.unregisterAll();
    }

    private void unregisterAll() {
        this.commands.clear();
    }
}

