/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.citizenscmd.mf.base;

import java.util.HashMap;
import java.util.Map;
import me.mattstudios.citizenscmd.mf.base.MessageHandler;
import me.mattstudios.citizenscmd.mf.base.components.ParameterResolver;
import me.mattstudios.citizenscmd.mf.base.components.Util;
import me.mattstudios.citizenscmd.mf.exceptions.InvalidArgException;
import me.mattstudios.citizenscmd.mf.exceptions.InvalidArgExceptionMsg;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ParameterHandler {
    private final Map<Class<?>, ParameterResolver> registeredTypes = new HashMap();
    private MessageHandler messageHandler;

    ParameterHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        this.register(Short.class, arg -> {
            try {
                return this.tryParseNumber(Short.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgException("arg.must.be.number");
            }
        });
        this.register(Short.TYPE, arg -> {
            try {
                return this.tryParseNumber(Short.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgException("arg.must.be.number");
            }
        });
        this.register(Integer.TYPE, arg -> {
            try {
                return this.tryParseNumber(Integer.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgException("arg.must.be.number");
            }
        });
        this.register(Integer.class, arg -> {
            try {
                return this.tryParseNumber(Integer.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgException("arg.must.be.number");
            }
        });
        this.register(Long.TYPE, arg -> {
            try {
                return this.tryParseNumber(Long.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgException("arg.must.be.number");
            }
        });
        this.register(Long.class, arg -> {
            try {
                return this.tryParseNumber(Long.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgException("arg.must.be.number");
            }
        });
        this.register(Float.TYPE, arg -> {
            try {
                return this.tryParseNumber(Float.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgException("arg.must.be.number");
            }
        });
        this.register(Float.class, arg -> {
            try {
                return this.tryParseNumber(Float.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgException("arg.must.be.number");
            }
        });
        this.register(Double.TYPE, arg -> {
            try {
                return this.tryParseNumber(Double.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgException("arg.must.be.number");
            }
        });
        this.register(Double.class, arg -> {
            try {
                return this.tryParseNumber(Double.class, String.valueOf(arg));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgException("arg.must.be.number");
            }
        });
        this.register(String.class, arg -> {
            if (arg instanceof String) {
                return arg;
            }
            throw new InvalidArgException("cmd.wrong.usage");
        });
        this.register(String[].class, arg -> {
            if (arg instanceof String[]) {
                return arg;
            }
            throw new InvalidArgException("cmd.wrong.usage");
        });
        this.register(Player.class, arg -> {
            Player player = Bukkit.getServer().getPlayer(String.valueOf(arg));
            if (player != null) {
                return player;
            }
            throw new InvalidArgException("arg.must.be.player");
        });
        this.register(Material.class, arg -> {
            Material material = Material.matchMaterial((String)String.valueOf(arg));
            if (material != null) {
                return material;
            }
            throw new InvalidArgException("arg.invalid.value");
        });
    }

    public void register(Class<?> clss, ParameterResolver parameterResolver) {
        this.registeredTypes.put(clss, parameterResolver);
    }

    Object getTypeResult(Class<?> clss, Object object, CommandSender sender) {
        try {
            return this.registeredTypes.get(clss).getResolved(object);
        }
        catch (InvalidArgException e) {
            this.messageHandler.sendMessage(e.getMessageId(), sender, String.valueOf(object));
            return null;
        }
        catch (InvalidArgExceptionMsg e) {
            sender.sendMessage(Util.color(e.getMessage()));
            return null;
        }
    }

    boolean isRegisteredType(Class<?> clss) {
        return this.registeredTypes.containsKey(clss);
    }

    private Number tryParseNumber(Class<?> clss, String number) throws NumberFormatException {
        switch (clss.getName()) {
            case "java.lang.Short": {
                return Short.parseShort(number);
            }
            case "java.lang.Integer": {
                return Integer.parseInt(number);
            }
            case "java.lang.Long": {
                return Long.parseLong(number);
            }
            case "java.lang.Float": {
                return Float.valueOf(Float.parseFloat(number));
            }
            case "java.lang.Double": {
                return Double.parseDouble(number);
            }
        }
        throw new NumberFormatException();
    }
}

