/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.citizenscmd.utility;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import me.mattstudios.citizenscmd.commons.FileUtils;
import org.simpleyaml.configuration.file.YamlFile;
import org.simpleyaml.exceptions.InvalidConfigurationException;

public class YamlUtils {
    public static void copyDefaults(InputStream inputFile, File outputFile) {
        try {
            if (inputFile == null) {
                return;
            }
            File tempFile = File.createTempFile("npcmdCfg" + YamlUtils.gen(), "yml");
            FileUtils.copyInputStreamToFile(inputFile, tempFile);
            inputFile.close();
            YamlFile originalYaml = new YamlFile(tempFile);
            YamlFile newYaml = new YamlFile(outputFile);
            originalYaml.load();
            newYaml.load();
            boolean edited = false;
            for (String path : originalYaml.getKeys(true)) {
                if (!newYaml.contains(path)) continue;
                edited = true;
                originalYaml.set(path, newYaml.get(path));
            }
            if (edited) {
                originalYaml.saveWithComments();
            }
            FileUtils.copyFile(tempFile, outputFile);
            tempFile.delete();
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    private static int gen() {
        Random r = new Random(System.currentTimeMillis());
        return 10000 + r.nextInt(20000);
    }
}

