/*
 * Decompiled with CFR 0.152.
 */
package org.simpleyaml.configuration.file;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import me.mattstudios.citizenscmd.commons.output.FileWriterWithEncoding;
import org.simpleyaml.configuration.file.YamlConfiguration;
import org.simpleyaml.exceptions.InvalidConfigurationException;
import org.simpleyaml.utils.Validate;

public class YamlFile
extends YamlConfiguration {
    private File configFile;

    public YamlFile(FileInputStream fileInputStream, String utf8) {
    }

    public YamlFile(String path) throws IllegalArgumentException {
        this.setConfigurationFile(path);
    }

    public YamlFile(File file) throws IllegalArgumentException {
        this.setConfigurationFile(file);
    }

    public void save() throws IOException {
        Validate.notNull(this.configFile, "This configuration file is null!");
        this.save(this.configFile);
    }

    public void saveWithComments() throws IOException {
        Validate.notNull(this.configFile, "This configuration file is null!");
        File old = File.createTempFile("tmp\\oldFileData", null);
        if (this.configFile.exists()) {
            this.copyTo(old);
        }
        this.save(this.configFile);
        if (old != null) {
            this.copyComments(old);
            old.delete();
        }
    }

    private void copyComments(File from) throws IOException {
        String comment;
        BufferedReader r_from = new BufferedReader(new FileReader(from));
        BufferedReader r_new = new BufferedReader(new FileReader(this.configFile));
        StringBuilder res = new StringBuilder();
        String line_from = r_from.readLine();
        String line_new = r_new.readLine();
        HashMap<String, String> comments = new HashMap<String, String>();
        while (line_from != null) {
            String trim = line_from.trim();
            if (trim.isEmpty() || trim.startsWith("#")) {
                StringBuilder comment2 = new StringBuilder(line_from.length());
                comment2.append(line_from).append('\n');
                line_from = r_from.readLine();
                while (line_from != null && ((trim = line_from.trim()).isEmpty() || trim.startsWith("#"))) {
                    comment2.append(line_from).append('\n');
                    line_from = r_from.readLine();
                }
                comments.put(this.substring(line_from, ':'), comment2.toString());
                continue;
            }
            line_from = r_from.readLine();
        }
        r_from.close();
        r_from = new BufferedReader(new FileReader(from));
        int commentsWritten = 0;
        int n = comments.size();
        while (line_new != null) {
            if (commentsWritten < n && (comment = (String)comments.get(this.substring(line_new, ':'))) != null) {
                res.append(comment);
                ++commentsWritten;
            }
            if (!line_new.trim().startsWith("#")) {
                res.append(line_new).append('\n');
            }
            line_new = r_new.readLine();
        }
        comment = (String)comments.get(null);
        if (comment != null) {
            res.append(comment);
        }
        BufferedWriter out = new BufferedWriter(new FileWriterWithEncoding(this.configFile, "UTF-8", false));
        out.write(res.toString());
        out.close();
        r_from.close();
        r_new.close();
    }

    private String substring(String s, char c) {
        if (s != null) {
            char charAt;
            int n = s.length();
            StringBuilder aux = new StringBuilder(n);
            for (int i = 0; i < n && (charAt = s.charAt(i)) != c; ++i) {
                aux.append(charAt);
            }
            return aux.toString();
        }
        return null;
    }

    public File copyTo(String path) throws FileNotFoundException, IllegalArgumentException, IOException {
        Validate.notNull(path, "Path cannot be null.");
        File copy = new File(path);
        this.copyTo(copy);
        return copy;
    }

    public void copyTo(File file) throws FileNotFoundException, IllegalArgumentException, IOException {
        Validate.notNull(this.configFile, "This configuration file is null!");
        if (!this.configFile.exists()) {
            throw new FileNotFoundException(this.configFile.getName() + " is not found in " + this.configFile.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is a directory!");
        }
        Files.copy((File)this.configFile, (File)file);
    }

    public void load() throws InvalidConfigurationException, IOException {
        Validate.notNull(this.configFile, "This configuration file is null!");
        this.options().copyDefaults(true);
        this.options().copyHeader(true);
        this.load(this.configFile);
    }

    public boolean exists() {
        Validate.notNull(this.configFile, "This configuration file is null!");
        return this.configFile.exists();
    }

    public void createNewFile(boolean overwrite) throws IOException {
        Validate.notNull(this.configFile, "This configuration file is null!");
        if (overwrite || !this.configFile.exists()) {
            try {
                File parents = this.configFile.getParentFile();
                if (parents != null) {
                    parents.mkdirs();
                }
                this.configFile.createNewFile();
            }
            catch (SecurityException e) {
                throw new IOException(e.getMessage(), e.getCause());
            }
        }
    }

    public void deleteFile() throws IOException {
        Validate.notNull(this.configFile, "This configuration file is null!");
        if (!this.configFile.delete()) {
            throw new IOException("Failed to delete " + this.configFile);
        }
    }

    public long getSize() {
        return this.configFile.length();
    }

    public String getFilePath() {
        Validate.notNull(this.configFile, "This configuration file is null!");
        return this.configFile.getAbsolutePath();
    }

    public File getConfigurationFile() {
        return this.configFile;
    }

    public void setConfigurationFile(String path) throws IllegalArgumentException {
        Validate.notNull(path, "Path cannot be null.");
        this.configFile = new File(path);
        if (this.configFile.isDirectory()) {
            this.configFile = null;
            throw new IllegalArgumentException(this.configFile.getName() + " is a directory!");
        }
    }

    public void setConfigurationFile(File file) throws IllegalArgumentException {
        Validate.notNull(file, "File cannot be null.");
        this.configFile = file;
        if (this.configFile.isDirectory()) {
            this.configFile = null;
            throw new IllegalArgumentException(this.configFile.getName() + " is a directory!");
        }
    }

    public void remove(String path) {
        this.set(path, null);
    }
}

