/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.command;

import com.github.steveice10.mc.protocol.data.game.command.CommandParser;
import com.github.steveice10.mc.protocol.data.game.command.CommandType;
import com.github.steveice10.mc.protocol.data.game.command.properties.CommandProperties;
import java.util.Arrays;
import java.util.OptionalInt;
import lombok.NonNull;

public class CommandNode {
    @NonNull
    private final CommandType type;
    private final boolean executable;
    @NonNull
    private final int[] childIndices;
    private final OptionalInt redirectIndex;
    private final String name;
    private final CommandParser parser;
    private final CommandProperties properties;
    private final String suggestionType;

    @NonNull
    public CommandType getType() {
        return this.type;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    @NonNull
    public int[] getChildIndices() {
        return this.childIndices;
    }

    public OptionalInt getRedirectIndex() {
        return this.redirectIndex;
    }

    public String getName() {
        return this.name;
    }

    public CommandParser getParser() {
        return this.parser;
    }

    public CommandProperties getProperties() {
        return this.properties;
    }

    public String getSuggestionType() {
        return this.suggestionType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandNode)) {
            return false;
        }
        CommandNode other = (CommandNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isExecutable() != other.isExecutable()) {
            return false;
        }
        CommandType this$type = this.getType();
        CommandType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        if (!Arrays.equals(this.getChildIndices(), other.getChildIndices())) {
            return false;
        }
        OptionalInt this$redirectIndex = this.getRedirectIndex();
        OptionalInt other$redirectIndex = other.getRedirectIndex();
        if (this$redirectIndex == null ? other$redirectIndex != null : !((Object)this$redirectIndex).equals(other$redirectIndex)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        CommandParser this$parser = this.getParser();
        CommandParser other$parser = other.getParser();
        if (this$parser == null ? other$parser != null : !((Object)((Object)this$parser)).equals((Object)other$parser)) {
            return false;
        }
        CommandProperties this$properties = this.getProperties();
        CommandProperties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        String this$suggestionType = this.getSuggestionType();
        String other$suggestionType = other.getSuggestionType();
        return !(this$suggestionType == null ? other$suggestionType != null : !this$suggestionType.equals(other$suggestionType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommandNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isExecutable() ? 79 : 97);
        CommandType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getChildIndices());
        OptionalInt $redirectIndex = this.getRedirectIndex();
        result = result * 59 + ($redirectIndex == null ? 43 : ((Object)$redirectIndex).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        CommandParser $parser = this.getParser();
        result = result * 59 + ($parser == null ? 43 : ((Object)((Object)$parser)).hashCode());
        CommandProperties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        String $suggestionType = this.getSuggestionType();
        result = result * 59 + ($suggestionType == null ? 43 : $suggestionType.hashCode());
        return result;
    }

    public String toString() {
        return "CommandNode(type=" + (Object)((Object)this.getType()) + ", executable=" + this.isExecutable() + ", childIndices=" + Arrays.toString(this.getChildIndices()) + ", redirectIndex=" + this.getRedirectIndex() + ", name=" + this.getName() + ", parser=" + (Object)((Object)this.getParser()) + ", properties=" + this.getProperties() + ", suggestionType=" + this.getSuggestionType() + ")";
    }

    public CommandNode(@NonNull CommandType type, boolean executable, @NonNull int[] childIndices, OptionalInt redirectIndex, String name, CommandParser parser, CommandProperties properties, String suggestionType) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (childIndices == null) {
            throw new NullPointerException("childIndices is marked non-null but is null");
        }
        this.type = type;
        this.executable = executable;
        this.childIndices = childIndices;
        this.redirectIndex = redirectIndex;
        this.name = name;
        this.parser = parser;
        this.properties = properties;
        this.suggestionType = suggestionType;
    }
}

