/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class ClientboundSetTimePacket
implements MinecraftPacket {
    private final long worldAge;
    private final long time;

    public ClientboundSetTimePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.worldAge = in.readLong();
        this.time = in.readLong();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeLong(this.worldAge);
        out.writeLong(this.time);
    }

    public long getWorldAge() {
        return this.worldAge;
    }

    public long getTime() {
        return this.time;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetTimePacket)) {
            return false;
        }
        ClientboundSetTimePacket other = (ClientboundSetTimePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWorldAge() != other.getWorldAge()) {
            return false;
        }
        return this.getTime() == other.getTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetTimePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $worldAge = this.getWorldAge();
        result = result * 59 + (int)($worldAge >>> 32 ^ $worldAge);
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        return result;
    }

    public String toString() {
        return "ClientboundSetTimePacket(worldAge=" + this.getWorldAge() + ", time=" + this.getTime() + ")";
    }

    public ClientboundSetTimePacket withWorldAge(long worldAge) {
        return this.worldAge == worldAge ? this : new ClientboundSetTimePacket(worldAge, this.time);
    }

    public ClientboundSetTimePacket withTime(long time) {
        return this.time == time ? this : new ClientboundSetTimePacket(this.worldAge, time);
    }

    public ClientboundSetTimePacket(long worldAge, long time) {
        this.worldAge = worldAge;
        this.time = time;
    }
}

