/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ServerboundPlaceRecipePacket
implements MinecraftPacket {
    private final int containerId;
    @NonNull
    private final String recipeId;
    private final boolean makeAll;

    public ServerboundPlaceRecipePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.containerId = in.readByte();
        this.recipeId = helper.readString(in);
        this.makeAll = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeByte(this.containerId);
        helper.writeString(out, this.recipeId);
        out.writeBoolean(this.makeAll);
    }

    public int getContainerId() {
        return this.containerId;
    }

    @NonNull
    public String getRecipeId() {
        return this.recipeId;
    }

    public boolean isMakeAll() {
        return this.makeAll;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundPlaceRecipePacket)) {
            return false;
        }
        ServerboundPlaceRecipePacket other = (ServerboundPlaceRecipePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        if (this.isMakeAll() != other.isMakeAll()) {
            return false;
        }
        String this$recipeId = this.getRecipeId();
        String other$recipeId = other.getRecipeId();
        return !(this$recipeId == null ? other$recipeId != null : !this$recipeId.equals(other$recipeId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundPlaceRecipePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        result = result * 59 + (this.isMakeAll() ? 79 : 97);
        String $recipeId = this.getRecipeId();
        result = result * 59 + ($recipeId == null ? 43 : $recipeId.hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundPlaceRecipePacket(containerId=" + this.getContainerId() + ", recipeId=" + this.getRecipeId() + ", makeAll=" + this.isMakeAll() + ")";
    }

    public ServerboundPlaceRecipePacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ServerboundPlaceRecipePacket(containerId, this.recipeId, this.makeAll);
    }

    public ServerboundPlaceRecipePacket withRecipeId(@NonNull String recipeId) {
        if (recipeId == null) {
            throw new NullPointerException("recipeId is marked non-null but is null");
        }
        return this.recipeId == recipeId ? this : new ServerboundPlaceRecipePacket(this.containerId, recipeId, this.makeAll);
    }

    public ServerboundPlaceRecipePacket withMakeAll(boolean makeAll) {
        return this.makeAll == makeAll ? this : new ServerboundPlaceRecipePacket(this.containerId, this.recipeId, makeAll);
    }

    public ServerboundPlaceRecipePacket(int containerId, @NonNull String recipeId, boolean makeAll) {
        if (recipeId == null) {
            throw new NullPointerException("recipeId is marked non-null but is null");
        }
        this.containerId = containerId;
        this.recipeId = recipeId;
        this.makeAll = makeAll;
    }
}

