/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;
import org.cloudburstmc.math.vector.Vector3i;

public class ServerboundSetJigsawBlockPacket
implements MinecraftPacket {
    @NonNull
    private final Vector3i position;
    @NonNull
    private final String name;
    @NonNull
    private final String target;
    @NonNull
    private final String pool;
    @NonNull
    private final String finalState;
    @NonNull
    private final String jointType;
    private final int selectionPriority;
    private final int placementPriority;

    public ServerboundSetJigsawBlockPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.position = helper.readPosition(in);
        this.name = helper.readString(in);
        this.target = helper.readString(in);
        this.pool = helper.readString(in);
        this.finalState = helper.readString(in);
        this.jointType = helper.readString(in);
        this.selectionPriority = helper.readVarInt(in);
        this.placementPriority = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writePosition(out, this.position);
        helper.writeString(out, this.name);
        helper.writeString(out, this.target);
        helper.writeString(out, this.pool);
        helper.writeString(out, this.finalState);
        helper.writeString(out, this.jointType);
        helper.writeVarInt(out, this.selectionPriority);
        helper.writeVarInt(out, this.placementPriority);
    }

    @NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getTarget() {
        return this.target;
    }

    @NonNull
    public String getPool() {
        return this.pool;
    }

    @NonNull
    public String getFinalState() {
        return this.finalState;
    }

    @NonNull
    public String getJointType() {
        return this.jointType;
    }

    public int getSelectionPriority() {
        return this.selectionPriority;
    }

    public int getPlacementPriority() {
        return this.placementPriority;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSetJigsawBlockPacket)) {
            return false;
        }
        ServerboundSetJigsawBlockPacket other = (ServerboundSetJigsawBlockPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSelectionPriority() != other.getSelectionPriority()) {
            return false;
        }
        if (this.getPlacementPriority() != other.getPlacementPriority()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        String this$pool = this.getPool();
        String other$pool = other.getPool();
        if (this$pool == null ? other$pool != null : !this$pool.equals(other$pool)) {
            return false;
        }
        String this$finalState = this.getFinalState();
        String other$finalState = other.getFinalState();
        if (this$finalState == null ? other$finalState != null : !this$finalState.equals(other$finalState)) {
            return false;
        }
        String this$jointType = this.getJointType();
        String other$jointType = other.getJointType();
        return !(this$jointType == null ? other$jointType != null : !this$jointType.equals(other$jointType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundSetJigsawBlockPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSelectionPriority();
        result = result * 59 + this.getPlacementPriority();
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        String $pool = this.getPool();
        result = result * 59 + ($pool == null ? 43 : $pool.hashCode());
        String $finalState = this.getFinalState();
        result = result * 59 + ($finalState == null ? 43 : $finalState.hashCode());
        String $jointType = this.getJointType();
        result = result * 59 + ($jointType == null ? 43 : $jointType.hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundSetJigsawBlockPacket(position=" + this.getPosition() + ", name=" + this.getName() + ", target=" + this.getTarget() + ", pool=" + this.getPool() + ", finalState=" + this.getFinalState() + ", jointType=" + this.getJointType() + ", selectionPriority=" + this.getSelectionPriority() + ", placementPriority=" + this.getPlacementPriority() + ")";
    }

    public ServerboundSetJigsawBlockPacket withPosition(@NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerboundSetJigsawBlockPacket(position, this.name, this.target, this.pool, this.finalState, this.jointType, this.selectionPriority, this.placementPriority);
    }

    public ServerboundSetJigsawBlockPacket withName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new ServerboundSetJigsawBlockPacket(this.position, name, this.target, this.pool, this.finalState, this.jointType, this.selectionPriority, this.placementPriority);
    }

    public ServerboundSetJigsawBlockPacket withTarget(@NonNull String target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        return this.target == target ? this : new ServerboundSetJigsawBlockPacket(this.position, this.name, target, this.pool, this.finalState, this.jointType, this.selectionPriority, this.placementPriority);
    }

    public ServerboundSetJigsawBlockPacket withPool(@NonNull String pool) {
        if (pool == null) {
            throw new NullPointerException("pool is marked non-null but is null");
        }
        return this.pool == pool ? this : new ServerboundSetJigsawBlockPacket(this.position, this.name, this.target, pool, this.finalState, this.jointType, this.selectionPriority, this.placementPriority);
    }

    public ServerboundSetJigsawBlockPacket withFinalState(@NonNull String finalState) {
        if (finalState == null) {
            throw new NullPointerException("finalState is marked non-null but is null");
        }
        return this.finalState == finalState ? this : new ServerboundSetJigsawBlockPacket(this.position, this.name, this.target, this.pool, finalState, this.jointType, this.selectionPriority, this.placementPriority);
    }

    public ServerboundSetJigsawBlockPacket withJointType(@NonNull String jointType) {
        if (jointType == null) {
            throw new NullPointerException("jointType is marked non-null but is null");
        }
        return this.jointType == jointType ? this : new ServerboundSetJigsawBlockPacket(this.position, this.name, this.target, this.pool, this.finalState, jointType, this.selectionPriority, this.placementPriority);
    }

    public ServerboundSetJigsawBlockPacket withSelectionPriority(int selectionPriority) {
        return this.selectionPriority == selectionPriority ? this : new ServerboundSetJigsawBlockPacket(this.position, this.name, this.target, this.pool, this.finalState, this.jointType, selectionPriority, this.placementPriority);
    }

    public ServerboundSetJigsawBlockPacket withPlacementPriority(int placementPriority) {
        return this.placementPriority == placementPriority ? this : new ServerboundSetJigsawBlockPacket(this.position, this.name, this.target, this.pool, this.finalState, this.jointType, this.selectionPriority, placementPriority);
    }

    public ServerboundSetJigsawBlockPacket(@NonNull Vector3i position, @NonNull String name, @NonNull String target, @NonNull String pool, @NonNull String finalState, @NonNull String jointType, int selectionPriority, int placementPriority) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (pool == null) {
            throw new NullPointerException("pool is marked non-null but is null");
        }
        if (finalState == null) {
            throw new NullPointerException("finalState is marked non-null but is null");
        }
        if (jointType == null) {
            throw new NullPointerException("jointType is marked non-null but is null");
        }
        this.position = position;
        this.name = name;
        this.target = target;
        this.pool = pool;
        this.finalState = finalState;
        this.jointType = jointType;
        this.selectionPriority = selectionPriority;
        this.placementPriority = placementPriority;
    }
}

