/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.netty.handler.codec.raknet.client;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import org.cloudburstmc.netty.channel.raknet.RakClientChannel;
import org.cloudburstmc.netty.channel.raknet.config.RakMetrics;

public class RakClientProxyRouteHandler
extends ChannelDuplexHandler {
    public static final String NAME = "rak-client-proxy-route-handler";
    private final RakClientChannel channel;

    public RakClientProxyRouteHandler(RakClientChannel channel) {
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof DatagramPacket)) {
            ctx.fireChannelRead(msg);
            return;
        }
        DatagramPacket packet = (DatagramPacket)msg;
        RakMetrics metrics = this.channel.config().getMetrics();
        if (metrics != null) {
            metrics.bytesIn(((ByteBuf)packet.content()).readableBytes());
        }
        DatagramPacket datagram = packet.retain();
        try {
            if (packet.sender() == null || ((InetSocketAddress)packet.sender()).equals(this.channel.remoteAddress())) {
                ctx.fireChannelRead(datagram.content());
            } else {
                ctx.fireChannelRead((Object)datagram);
            }
        }
        finally {
            datagram.release();
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        boolean isDatagram = msg instanceof DatagramPacket;
        if (!isDatagram && !(msg instanceof ByteBuf)) {
            ctx.write(msg, promise);
            return;
        }
        DatagramPacket datagram = isDatagram ? (DatagramPacket)msg : new DatagramPacket((ByteBuf)msg, this.channel.remoteAddress());
        RakMetrics metrics = this.channel.config().getMetrics();
        if (metrics != null) {
            metrics.bytesOut(((ByteBuf)datagram.content()).readableBytes());
        }
        ctx.write((Object)datagram, promise);
    }
}

