/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe;

import java.util.List;
import java.util.UUID;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.CraftingDataType;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.CraftingRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import org.cloudburstmc.protocol.common.util.Preconditions;

public class ShapedRecipeData
implements CraftingRecipeData {
    private final CraftingDataType type;
    private final String id;
    private final int width;
    private final int height;
    private final List<ItemDescriptorWithCount> ingredients;
    private final List<ItemData> results;
    private final UUID uuid;
    private final String tag;
    private final int priority;
    private final int netId;

    public static ShapedRecipeData of(CraftingDataType type, String id, int width, int height, List<ItemDescriptorWithCount> ingredients, List<ItemData> results, UUID uuid, String tag, int priority, int netId) {
        Preconditions.checkArgument(type == CraftingDataType.SHAPED || type == CraftingDataType.SHAPED_CHEMISTRY, "type must be SHAPED or SHAPED_CHEMISTRY");
        return new ShapedRecipeData(type, id, width, height, ingredients, results, uuid, tag, priority, netId);
    }

    public static ShapedRecipeData shaped(String id, int width, int height, List<ItemDescriptorWithCount> ingredients, List<ItemData> results, UUID uuid, String tag, int priority, int netId) {
        return ShapedRecipeData.of(CraftingDataType.SHAPED, id, width, height, ingredients, results, uuid, tag, priority, netId);
    }

    public static ShapedRecipeData shapedChemistry(String id, int width, int height, List<ItemDescriptorWithCount> ingredients, List<ItemData> results, UUID uuid, String tag, int priority, int netId) {
        return ShapedRecipeData.of(CraftingDataType.SHAPED_CHEMISTRY, id, width, height, ingredients, results, uuid, tag, priority, netId);
    }

    @Override
    public CraftingDataType getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public List<ItemDescriptorWithCount> getIngredients() {
        return this.ingredients;
    }

    @Override
    public List<ItemData> getResults() {
        return this.results;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getNetId() {
        return this.netId;
    }

    public String toString() {
        return "ShapedRecipeData(type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", ingredients=" + this.getIngredients() + ", results=" + this.getResults() + ", uuid=" + this.getUuid() + ", tag=" + this.getTag() + ", priority=" + this.getPriority() + ", netId=" + this.getNetId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShapedRecipeData)) {
            return false;
        }
        ShapedRecipeData other = (ShapedRecipeData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        if (this.getNetId() != other.getNetId()) {
            return false;
        }
        CraftingDataType this$type = this.getType();
        CraftingDataType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<ItemDescriptorWithCount> this$ingredients = this.getIngredients();
        List<ItemDescriptorWithCount> other$ingredients = other.getIngredients();
        if (this$ingredients == null ? other$ingredients != null : !((Object)this$ingredients).equals(other$ingredients)) {
            return false;
        }
        List<ItemData> this$results = this.getResults();
        List<ItemData> other$results = other.getResults();
        if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShapedRecipeData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        result = result * 59 + this.getPriority();
        result = result * 59 + this.getNetId();
        CraftingDataType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<ItemDescriptorWithCount> $ingredients = this.getIngredients();
        result = result * 59 + ($ingredients == null ? 43 : ((Object)$ingredients).hashCode());
        List<ItemData> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        return result;
    }

    private ShapedRecipeData(CraftingDataType type, String id, int width, int height, List<ItemDescriptorWithCount> ingredients, List<ItemData> results, UUID uuid, String tag, int priority, int netId) {
        this.type = type;
        this.id = id;
        this.width = width;
        this.height = height;
        this.ingredients = ingredients;
        this.results = results;
        this.uuid = uuid;
        this.tag = tag;
        this.priority = priority;
        this.netId = netId;
    }
}

