/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.netty.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;
import org.cloudburstmc.protocol.bedrock.data.PacketCompressionAlgorithm;
import org.cloudburstmc.protocol.bedrock.netty.codec.compression.CompressionCodec;
import org.cloudburstmc.protocol.common.util.Zlib;

public class ZlibCompressionCodec
extends MessageToMessageCodec<ByteBuf, ByteBuf>
implements CompressionCodec {
    public static final String NAME = "compression-codec";
    private static final int MAX_DECOMPRESSED_BYTES = Integer.getInteger("bedrock.maxDecompressedBytes", 0xA00000);
    private final Zlib zlib;
    private int level = 7;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        ByteBuf outBuf = ctx.alloc().ioBuffer(msg.readableBytes() << 3);
        try {
            this.zlib.deflate(msg, outBuf, this.level);
            out.add(outBuf.retain());
        }
        finally {
            outBuf.release();
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        out.add(this.zlib.inflate(msg, MAX_DECOMPRESSED_BYTES));
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public PacketCompressionAlgorithm getAlgorithm() {
        return PacketCompressionAlgorithm.ZLIB;
    }

    public ZlibCompressionCodec(Zlib zlib) {
        this.zlib = zlib;
    }
}

