/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.erosion.bukkit;

import java.util.ArrayList;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Lectern;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.plugin.Plugin;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.erosion.bukkit.BukkitUtils;
import org.geysermc.erosion.util.LecternUtils;
import org.jetbrains.annotations.Nullable;

public final class BukkitLecterns {
    private final Plugin plugin;

    public BukkitLecterns(Plugin plugin) {
        this.plugin = plugin;
    }

    @Nullable
    public NbtMap getLecternData(Block block, boolean isChunkLoad) {
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        BlockState state = BukkitUtils.getBlockState(block);
        if (!(state instanceof Lectern)) {
            this.plugin.getLogger().warning("Lectern expected at: " + Vector3i.from(x, y, z).toString() + " but was not! " + block.toString());
            return null;
        }
        Lectern lectern = (Lectern)state;
        ItemStack itemStack = lectern.getInventory().getItem(0);
        if (itemStack == null || !(itemStack.getItemMeta() instanceof BookMeta)) {
            if (!isChunkLoad) {
                return LecternUtils.getBaseLecternTag(x, y, z, 0).build();
            }
            return null;
        }
        BookMeta bookMeta = (BookMeta)itemStack.getItemMeta();
        boolean hasBookPages = bookMeta.getPageCount() > 0;
        NbtMapBuilder lecternTag = LecternUtils.getBaseLecternTag(x, y, z, hasBookPages ? bookMeta.getPageCount() : 1);
        lecternTag.putInt("page", lectern.getPage() / 2);
        NbtMapBuilder bookTag = NbtMap.builder().putByte("Count", (byte)itemStack.getAmount()).putShort("Damage", (short)0).putString("Name", "minecraft:writable_book");
        ArrayList<NbtMap> pages = new ArrayList<NbtMap>(bookMeta.getPageCount());
        if (hasBookPages) {
            for (String page : bookMeta.getPages()) {
                NbtMapBuilder pageBuilder = NbtMap.builder().putString("photoname", "").putString("text", page);
                pages.add(pageBuilder.build());
            }
        } else {
            NbtMapBuilder pageBuilder = NbtMap.builder().putString("photoname", "").putString("text", "");
            pages.add(pageBuilder.build());
        }
        bookTag.putCompound("tag", NbtMap.builder().putList("pages", NbtType.COMPOUND, pages).build());
        lecternTag.putCompound("book", bookTag.build());
        return lecternTag.build();
    }
}

