/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command.defaults;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.WebUtils;

public class VersionCommand
extends GeyserCommand {
    private final GeyserImpl geyser;

    public VersionCommand(GeyserImpl geyser, String name, String description, String permission) {
        super(name, description, permission);
        this.geyser = geyser;
    }

    @Override
    public void execute(GeyserSession session, GeyserCommandSource sender, String[] args) {
        block6: {
            List<BedrockCodec> supportedCodecs = GameProtocol.SUPPORTED_BEDROCK_CODECS;
            Object bedrockVersions = supportedCodecs.size() > 1 ? supportedCodecs.get(0).getMinecraftVersion() + " - " + supportedCodecs.get(supportedCodecs.size() - 1).getMinecraftVersion() : GameProtocol.SUPPORTED_BEDROCK_CODECS.get(0).getMinecraftVersion();
            List<String> supportedJavaVersions = GameProtocol.getJavaVersions();
            Object javaVersions = supportedJavaVersions.size() > 1 ? supportedJavaVersions.get(0) + " - " + supportedJavaVersions.get(supportedJavaVersions.size() - 1) : supportedJavaVersions.get(0);
            sender.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.version.version", sender.locale(), "Geyser", "2.2.0-SNAPSHOT (git-master-58ff00d)", javaVersions, bedrockVersions));
            if (GeyserImpl.getInstance().isProductionEnvironment() && (sender.isConsole() || this.geyser.getPlatformType() != PlatformType.STANDALONE)) {
                sender.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.version.checking", sender.locale()));
                try {
                    String buildXML = WebUtils.getBody("https://ci.opencollab.dev/job/GeyserMC/job/Geyser/job/" + URLEncoder.encode("master", StandardCharsets.UTF_8) + "/lastSuccessfulBuild/api/xml?xpath=//buildNumber");
                    if (buildXML.startsWith("<buildNumber>")) {
                        int buildNum;
                        int latestBuildNum = Integer.parseInt(buildXML.replaceAll("<(\\\\)?(/)?buildNumber>", "").trim());
                        if (latestBuildNum == (buildNum = this.geyser.buildNumber())) {
                            sender.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.version.no_updates", sender.locale()));
                        } else {
                            sender.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.version.outdated", sender.locale(), latestBuildNum - buildNum, "https://geysermc.org/download"));
                        }
                        break block6;
                    }
                    throw new AssertionError((Object)"buildNumber missing");
                }
                catch (Exception e) {
                    GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.commands.version.failed"), e);
                    sender.sendMessage("\u00a7c" + GeyserLocale.getPlayerLocaleString("geyser.commands.version.failed", sender.locale()));
                }
            }
        }
    }

    @Override
    public boolean isSuggestedOpOnly() {
        return true;
    }
}

