/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;

public class PigEntity
extends AnimalEntity {
    public PigEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    public boolean canEat(Item item) {
        return item == Items.CARROT || item == Items.POTATO || item == Items.BEETROOT;
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (!this.canEat(itemInHand) && this.getFlag(EntityFlag.SADDLED) && this.passengers.isEmpty() && !this.session.isSneaking()) {
            return InteractiveTag.MOUNT;
        }
        InteractiveTag superTag = super.testMobInteraction(hand, itemInHand);
        if (superTag != InteractiveTag.NONE) {
            return superTag;
        }
        return EntityUtils.attemptToSaddle(this, itemInHand).consumesAction() ? InteractiveTag.SADDLE : InteractiveTag.NONE;
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (!this.canEat(itemInHand) && this.getFlag(EntityFlag.SADDLED) && this.passengers.isEmpty() && !this.session.isSneaking()) {
            return InteractionResult.SUCCESS;
        }
        InteractionResult superResult = super.mobInteract(hand, itemInHand);
        if (superResult.consumesAction()) {
            return superResult;
        }
        return EntityUtils.attemptToSaddle(this, itemInHand);
    }
}

