/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.horse;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.Pose;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityEventType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.packet.EntityEventPacket;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.horse.AbstractHorseEntity;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;

public class CamelEntity
extends AbstractHorseEntity {
    public static final float SITTING_HEIGHT_DIFFERENCE = 1.43f;

    public CamelEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
        this.dirtyMetadata.put(EntityDataTypes.CONTAINER_TYPE, (byte)ContainerType.HORSE.getId());
        this.setFlag(EntityFlag.TAMED, true);
    }

    @Override
    public void setHorseFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        boolean saddled = (xd & 4) == 4;
        this.setFlag(EntityFlag.SADDLED, saddled);
        this.setFlag(EntityFlag.EATING, (xd & 0x10) == 16);
        this.setFlag(EntityFlag.STANDING, (xd & 0x20) == 32);
        int horseFlags = 0;
        horseFlags = (xd & 0x40) == 64 ? horseFlags | 0x80 : horseFlags;
        horseFlags = (xd & 0x10) == 16 && (xd & 0x40) != 64 ? horseFlags | 0x20 : horseFlags;
        this.dirtyMetadata.put(EntityDataTypes.HORSE_FLAGS, horseFlags);
        if ((xd & 0x40) == 64) {
            EntityEventPacket entityEventPacket = new EntityEventPacket();
            entityEventPacket.setRuntimeEntityId(this.geyserId);
            entityEventPacket.setType(EntityEventType.EATING_ITEM);
            entityEventPacket.setData(this.session.getItemMappings().getStoredItems().wheat().getBedrockDefinition().getRuntimeId() << 16);
            this.session.sendUpstreamPacket(entityEventPacket);
        }
        this.setFlag(EntityFlag.CAN_DASH, saddled);
    }

    @Override
    public boolean canEat(Item item) {
        return item == Items.CACTUS;
    }

    @Override
    public void setPose(Pose pose) {
        this.setFlag(EntityFlag.SITTING, pose == Pose.SITTING);
        super.setPose(pose);
    }

    @Override
    protected void setDimensions(Pose pose) {
        if (pose == Pose.SITTING) {
            this.setBoundingBoxHeight(this.definition.height() - 1.43f);
            this.setBoundingBoxWidth(this.definition.width());
        } else {
            super.setDimensions(pose);
        }
    }

    public void setDashing(BooleanEntityMetadata entityMetadata) {
    }
}

