/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.horse;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.packet.MobArmorEquipmentPacket;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.horse.ChestedHorseEntity;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;

public class LlamaEntity
extends ChestedHorseEntity {
    public LlamaEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
        this.dirtyMetadata.put(EntityDataTypes.CONTAINER_STRENGTH_MODIFIER, 3);
    }

    public void setCarpetedColor(IntEntityMetadata entityMetadata) {
        MobArmorEquipmentPacket equipmentPacket = new MobArmorEquipmentPacket();
        equipmentPacket.setRuntimeEntityId(this.geyserId);
        int carpetIndex = entityMetadata.getPrimitiveValue();
        if (carpetIndex > -1 && carpetIndex <= 15) {
            equipmentPacket.setChestplate(this.session.getItemMappings().getCarpets().get(carpetIndex));
        } else {
            equipmentPacket.setChestplate(ItemData.AIR);
        }
        equipmentPacket.setBoots(ItemData.AIR);
        equipmentPacket.setHelmet(ItemData.AIR);
        equipmentPacket.setLeggings(ItemData.AIR);
        this.session.sendUpstreamPacket(equipmentPacket);
    }

    @Override
    public boolean canEat(Item item) {
        return item == Items.WHEAT || item == Items.HAY_BLOCK;
    }
}

