/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.item;

import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum Potion {
    WATER(0),
    MUNDANE(1),
    THICK(3),
    AWKWARD(4),
    NIGHT_VISION(5),
    LONG_NIGHT_VISION(6),
    INVISIBILITY(7),
    LONG_INVISIBILITY(8),
    LEAPING(9),
    STRONG_LEAPING(11),
    LONG_LEAPING(10),
    FIRE_RESISTANCE(12),
    LONG_FIRE_RESISTANCE(13),
    SWIFTNESS(14),
    STRONG_SWIFTNESS(16),
    LONG_SWIFTNESS(15),
    SLOWNESS(17),
    STRONG_SLOWNESS(42),
    LONG_SLOWNESS(18),
    WATER_BREATHING(19),
    LONG_WATER_BREATHING(20),
    HEALING(21),
    STRONG_HEALING(22),
    HARMING(23),
    STRONG_HARMING(24),
    POISON(25),
    STRONG_POISON(27),
    LONG_POISON(26),
    REGENERATION(28),
    STRONG_REGENERATION(30),
    LONG_REGENERATION(29),
    STRENGTH(31),
    STRONG_STRENGTH(33),
    LONG_STRENGTH(32),
    WEAKNESS(34),
    LONG_WEAKNESS(35),
    LUCK(2),
    TURTLE_MASTER(37),
    STRONG_TURTLE_MASTER(39),
    LONG_TURTLE_MASTER(38),
    SLOW_FALLING(40),
    LONG_SLOW_FALLING(41);

    public static final Potion[] VALUES;
    private final String javaIdentifier = "minecraft:" + this.name().toLowerCase(Locale.ENGLISH);
    private final short bedrockId;

    private Potion(int bedrockId) {
        this.bedrockId = (short)bedrockId;
    }

    public static @Nullable Potion getByJavaIdentifier(String javaIdentifier) {
        for (Potion potion : VALUES) {
            if (!potion.javaIdentifier.equals(javaIdentifier)) continue;
            return potion;
        }
        return null;
    }

    public static @Nullable Potion getByBedrockId(int bedrockId) {
        for (Potion potion : VALUES) {
            if (potion.bedrockId != bedrockId) continue;
            return potion;
        }
        return null;
    }

    public String getJavaIdentifier() {
        return this.javaIdentifier;
    }

    public short getBedrockId() {
        return this.bedrockId;
    }

    static {
        VALUES = Potion.values();
    }
}

