/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cloudburstmc.protocol.bedrock.data.TrimMaterial;
import org.cloudburstmc.protocol.bedrock.data.TrimPattern;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemTagDescriptor;

public class TrimRecipe {
    public static final List<TrimPattern> PATTERNS;
    public static final List<TrimMaterial> MATERIALS;
    public static final String ID = "minecraft:smithing_armor_trim";
    public static final ItemDescriptorWithCount BASE;
    public static final ItemDescriptorWithCount ADDITION;
    public static final ItemDescriptorWithCount TEMPLATE;

    private TrimRecipe() {
    }

    private static ItemDescriptorWithCount tagDescriptor(String tag) {
        return new ItemDescriptorWithCount(new ItemTagDescriptor(tag), 1);
    }

    static {
        BASE = TrimRecipe.tagDescriptor("minecraft:trimmable_armors");
        ADDITION = TrimRecipe.tagDescriptor("minecraft:trim_materials");
        TEMPLATE = TrimRecipe.tagDescriptor("minecraft:trim_templates");
        ArrayList<TrimPattern> patterns = new ArrayList<TrimPattern>(16);
        patterns.add(new TrimPattern("minecraft:ward_armor_trim_smithing_template", "ward"));
        patterns.add(new TrimPattern("minecraft:sentry_armor_trim_smithing_template", "sentry"));
        patterns.add(new TrimPattern("minecraft:snout_armor_trim_smithing_template", "snout"));
        patterns.add(new TrimPattern("minecraft:dune_armor_trim_smithing_template", "dune"));
        patterns.add(new TrimPattern("minecraft:spire_armor_trim_smithing_template", "spire"));
        patterns.add(new TrimPattern("minecraft:tide_armor_trim_smithing_template", "tide"));
        patterns.add(new TrimPattern("minecraft:wild_armor_trim_smithing_template", "wild"));
        patterns.add(new TrimPattern("minecraft:rib_armor_trim_smithing_template", "rib"));
        patterns.add(new TrimPattern("minecraft:coast_armor_trim_smithing_template", "coast"));
        patterns.add(new TrimPattern("minecraft:shaper_armor_trim_smithing_template", "shaper"));
        patterns.add(new TrimPattern("minecraft:eye_armor_trim_smithing_template", "eye"));
        patterns.add(new TrimPattern("minecraft:vex_armor_trim_smithing_template", "vex"));
        patterns.add(new TrimPattern("minecraft:silence_armor_trim_smithing_template", "silence"));
        patterns.add(new TrimPattern("minecraft:wayfinder_armor_trim_smithing_template", "wayfinder"));
        patterns.add(new TrimPattern("minecraft:raiser_armor_trim_smithing_template", "raiser"));
        patterns.add(new TrimPattern("minecraft:host_armor_trim_smithing_template", "host"));
        PATTERNS = Collections.unmodifiableList(patterns);
        ArrayList<TrimMaterial> materials = new ArrayList<TrimMaterial>(10);
        materials.add(new TrimMaterial("quartz", "\u00a7h", "minecraft:quartz"));
        materials.add(new TrimMaterial("iron", "\u00a7i", "minecraft:iron_ingot"));
        materials.add(new TrimMaterial("netherite", "\u00a7j", "minecraft:netherite_ingot"));
        materials.add(new TrimMaterial("redstone", "\u00a7m", "minecraft:redstone"));
        materials.add(new TrimMaterial("copper", "\u00a7n", "minecraft:copper_ingot"));
        materials.add(new TrimMaterial("gold", "\u00a7p", "minecraft:gold_ingot"));
        materials.add(new TrimMaterial("emerald", "\u00a7q", "minecraft:emerald"));
        materials.add(new TrimMaterial("diamond", "\u00a7s", "minecraft:diamond"));
        materials.add(new TrimMaterial("lapis", "\u00a7t", "minecraft:lapis_lazuli"));
        materials.add(new TrimMaterial("amethyst", "\u00a7u", "minecraft:amethyst_shard"));
        MATERIALS = Collections.unmodifiableList(materials);
    }
}

