/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.item.custom.CustomItemData;
import org.geysermc.geyser.api.item.custom.CustomItemOptions;
import org.geysermc.geyser.api.item.custom.CustomRenderOffsets;

public class GeyserCustomItemData
implements CustomItemData {
    private final String name;
    private final CustomItemOptions customItemOptions;
    private final String displayName;
    private final String icon;
    private final boolean allowOffhand;
    private final boolean displayHandheld;
    private final int textureSize;
    private final CustomRenderOffsets renderOffsets;
    private final Set<String> tags;

    public GeyserCustomItemData(String name, CustomItemOptions customItemOptions, String displayName, String icon, boolean allowOffhand, boolean displayHandheld, int textureSize, CustomRenderOffsets renderOffsets, Set<String> tags) {
        this.name = name;
        this.customItemOptions = customItemOptions;
        this.displayName = displayName;
        this.icon = icon;
        this.allowOffhand = allowOffhand;
        this.displayHandheld = displayHandheld;
        this.textureSize = textureSize;
        this.renderOffsets = renderOffsets;
        this.tags = tags;
    }

    @Override
    public @NonNull String name() {
        return this.name;
    }

    @Override
    public CustomItemOptions customItemOptions() {
        return this.customItemOptions;
    }

    @Override
    public @NonNull String displayName() {
        return this.displayName;
    }

    @Override
    public @NonNull String icon() {
        return this.icon;
    }

    @Override
    public boolean allowOffhand() {
        return this.allowOffhand;
    }

    @Override
    public boolean displayHandheld() {
        return this.displayHandheld;
    }

    @Override
    public int textureSize() {
        return this.textureSize;
    }

    @Override
    public CustomRenderOffsets renderOffsets() {
        return this.renderOffsets;
    }

    @Override
    public @NonNull Set<String> tags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeyserCustomItemData)) {
            return false;
        }
        GeyserCustomItemData other = (GeyserCustomItemData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.allowOffhand != other.allowOffhand) {
            return false;
        }
        if (this.displayHandheld != other.displayHandheld) {
            return false;
        }
        if (this.textureSize != other.textureSize) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        CustomItemOptions this$customItemOptions = this.customItemOptions;
        CustomItemOptions other$customItemOptions = other.customItemOptions;
        if (this$customItemOptions == null ? other$customItemOptions != null : !this$customItemOptions.equals(other$customItemOptions)) {
            return false;
        }
        String this$displayName = this.displayName;
        String other$displayName = other.displayName;
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$icon = this.icon;
        String other$icon = other.icon;
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        CustomRenderOffsets this$renderOffsets = this.renderOffsets;
        CustomRenderOffsets other$renderOffsets = other.renderOffsets;
        if (this$renderOffsets == null ? other$renderOffsets != null : !((Object)this$renderOffsets).equals(other$renderOffsets)) {
            return false;
        }
        Set<String> this$tags = this.tags;
        Set<String> other$tags = other.tags;
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeyserCustomItemData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.allowOffhand ? 79 : 97);
        result = result * 59 + (this.displayHandheld ? 79 : 97);
        result = result * 59 + this.textureSize;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        CustomItemOptions $customItemOptions = this.customItemOptions;
        result = result * 59 + ($customItemOptions == null ? 43 : $customItemOptions.hashCode());
        String $displayName = this.displayName;
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $icon = this.icon;
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        CustomRenderOffsets $renderOffsets = this.renderOffsets;
        result = result * 59 + ($renderOffsets == null ? 43 : ((Object)$renderOffsets).hashCode());
        Set<String> $tags = this.tags;
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "GeyserCustomItemData(name=" + this.name + ", customItemOptions=" + this.customItemOptions + ", displayName=" + this.displayName + ", icon=" + this.icon + ", allowOffhand=" + this.allowOffhand + ", displayHandheld=" + this.displayHandheld + ", textureSize=" + this.textureSize + ", renderOffsets=" + this.renderOffsets + ", tags=" + this.tags + ")";
    }

    public static class CustomItemDataBuilder
    implements CustomItemData.Builder {
        protected String name = null;
        protected CustomItemOptions customItemOptions = null;
        protected String displayName = null;
        protected String icon = null;
        protected boolean allowOffhand = true;
        protected boolean displayHandheld = false;
        protected int textureSize = 16;
        protected CustomRenderOffsets renderOffsets = null;
        protected Set<String> tags = new HashSet<String>();

        @Override
        public CustomItemData.Builder name(@NonNull String name) {
            this.name = name;
            return this;
        }

        @Override
        public CustomItemData.Builder customItemOptions(@NonNull CustomItemOptions customItemOptions) {
            this.customItemOptions = customItemOptions;
            return this;
        }

        @Override
        public CustomItemData.Builder displayName(@NonNull String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public CustomItemData.Builder icon(@NonNull String icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public CustomItemData.Builder allowOffhand(boolean allowOffhand) {
            this.allowOffhand = allowOffhand;
            return this;
        }

        @Override
        public CustomItemData.Builder displayHandheld(boolean displayHandheld) {
            this.displayHandheld = displayHandheld;
            return this;
        }

        @Override
        public CustomItemData.Builder textureSize(int textureSize) {
            this.textureSize = textureSize;
            return this;
        }

        @Override
        public CustomItemData.Builder renderOffsets(CustomRenderOffsets renderOffsets) {
            this.renderOffsets = renderOffsets;
            return this;
        }

        @Override
        public CustomItemData.Builder tags(@Nullable Set<String> tags) {
            this.tags = Objects.requireNonNullElseGet(tags, Set::of);
            return this;
        }

        @Override
        public CustomItemData build() {
            if (this.name == null || this.customItemOptions == null) {
                throw new IllegalArgumentException("Name and custom item options must be set");
            }
            if (this.displayName == null) {
                this.displayName = this.name;
            }
            if (this.icon == null) {
                this.icon = this.name;
            }
            return new GeyserCustomItemData(this.name, this.customItemOptions, this.displayName, this.icon, this.allowOffhand, this.displayHandheld, this.textureSize, this.renderOffsets, this.tags);
        }
    }
}

