/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.item.ArmorMaterial;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;

public class ArmorItem
extends Item {
    private final ArmorMaterial material;

    public ArmorItem(String javaIdentifier, ArmorMaterial material, Item.Builder builder) {
        super(javaIdentifier, builder);
        this.material = material;
    }

    @Override
    public void translateNbtToBedrock(@NonNull GeyserSession session, @NonNull CompoundTag tag) {
        super.translateNbtToBedrock(session, tag);
        Object t = tag.get("Trim");
        if (t instanceof CompoundTag) {
            CompoundTag trim = (CompoundTag)t;
            StringTag material = (StringTag)trim.remove("material");
            StringTag pattern = (StringTag)trim.remove("pattern");
            trim.put(new StringTag("Material", ArmorItem.stripNamespace(material.getValue())));
            trim.put(new StringTag("Pattern", ArmorItem.stripNamespace(pattern.getValue())));
        }
    }

    @Override
    public void translateNbtToJava(@NonNull CompoundTag tag, @NonNull ItemMapping mapping) {
        super.translateNbtToJava(tag, mapping);
        Object t = tag.get("Trim");
        if (t instanceof CompoundTag) {
            CompoundTag trim = (CompoundTag)t;
            StringTag material = (StringTag)trim.remove("Material");
            StringTag pattern = (StringTag)trim.remove("Pattern");
            trim.put(new StringTag("material", "minecraft:" + material.getValue()));
            trim.put(new StringTag("pattern", "minecraft:" + pattern.getValue()));
        }
    }

    @Override
    public boolean isValidRepairItem(Item other) {
        return this.material.getRepairIngredient() == other;
    }

    private static String stripNamespace(String identifier) {
        int i = identifier.indexOf(58);
        if (i >= 0) {
            return identifier.substring(i + 1);
        }
        return identifier;
    }
}

