/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.erosion.util.BannerUtils;
import org.geysermc.geyser.item.type.BlockItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;

public class BannerItem
extends BlockItem {
    public static final ListTag OMINOUS_BANNER_PATTERN = new ListTag("Patterns");

    public static NbtList<NbtMap> convertBannerPattern(ListTag patterns) {
        ArrayList<NbtMap> tagsList = new ArrayList<NbtMap>();
        Iterator iterator = patterns.getValue().iterator();
        while (iterator.hasNext()) {
            Tag patternTag = (Tag)iterator.next();
            tagsList.add(BannerItem.getBedrockBannerPattern((CompoundTag)patternTag));
        }
        return new NbtList<NbtMap>(NbtType.COMPOUND, (Collection<NbtMap>)tagsList);
    }

    private static @NonNull NbtMap getBedrockBannerPattern(CompoundTag pattern) {
        return NbtMap.builder().putInt("Color", 15 - (Integer)((Tag)pattern.get("Color")).getValue()).putString("Pattern", (String)((Tag)pattern.get("Pattern")).getValue()).build();
    }

    public static CompoundTag getJavaBannerPattern(NbtMap pattern) {
        return BannerUtils.getJavaPatternTag(pattern.getString("Pattern"), 15 - pattern.getInt("Color"));
    }

    private void invertBannerColors(ListTag patterns) {
        Iterator iterator = patterns.getValue().iterator();
        while (iterator.hasNext()) {
            Tag patternTag = (Tag)iterator.next();
            IntTag color = (IntTag)((CompoundTag)patternTag).get("Color");
            color.setValue(15 - color.getValue());
        }
    }

    public BannerItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateNbtToBedrock(@NonNull GeyserSession session, @NonNull CompoundTag tag) {
        Object t;
        super.translateNbtToBedrock(session, tag);
        CompoundTag blockEntityTag = (CompoundTag)tag.remove("BlockEntityTag");
        if (blockEntityTag != null && (t = blockEntityTag.get("Patterns")) instanceof ListTag) {
            ListTag patterns = (ListTag)t;
            if (patterns.equals(OMINOUS_BANNER_PATTERN)) {
                tag.put(new IntTag("Type", 1));
            } else {
                this.invertBannerColors(patterns);
                tag.put(patterns);
            }
        }
    }

    @Override
    public void translateNbtToJava(@NonNull CompoundTag tag, @NonNull ItemMapping mapping) {
        IntTag type;
        super.translateNbtToJava(tag, mapping);
        Object t = tag.get("Type");
        if (t instanceof IntTag && (type = (IntTag)t).getValue() == 1) {
            tag.remove("Type");
            blockEntityTag = new CompoundTag("BlockEntityTag");
            ((CompoundTag)blockEntityTag).put((ListTag)OMINOUS_BANNER_PATTERN);
            tag.put(blockEntityTag);
        } else {
            blockEntityTag = tag.get("Patterns");
            if (blockEntityTag instanceof ListTag) {
                ListTag patterns = (ListTag)blockEntityTag;
                blockEntityTag = new CompoundTag("BlockEntityTag");
                this.invertBannerColors(patterns);
                ((CompoundTag)blockEntityTag).put(patterns);
                tag.put(blockEntityTag);
                tag.remove("Patterns");
            }
        }
    }

    static {
        OMINOUS_BANNER_PATTERN.add(BannerUtils.getJavaPatternTag("mr", 9));
        OMINOUS_BANNER_PATTERN.add(BannerUtils.getJavaPatternTag("bs", 8));
        OMINOUS_BANNER_PATTERN.add(BannerUtils.getJavaPatternTag("cs", 7));
        OMINOUS_BANNER_PATTERN.add(BannerUtils.getJavaPatternTag("bo", 8));
        OMINOUS_BANNER_PATTERN.add(BannerUtils.getJavaPatternTag("ms", 15));
        OMINOUS_BANNER_PATTERN.add(BannerUtils.getJavaPatternTag("hh", 8));
        OMINOUS_BANNER_PATTERN.add(BannerUtils.getJavaPatternTag("mc", 8));
        OMINOUS_BANNER_PATTERN.add(BannerUtils.getJavaPatternTag("bo", 15));
    }
}

