/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.ShortTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;

public class CrossbowItem
extends Item {
    public CrossbowItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateNbtToBedrock(@NonNull GeyserSession session, @NonNull CompoundTag tag) {
        super.translateNbtToBedrock(session, tag);
        ListTag chargedProjectiles = (ListTag)tag.get("ChargedProjectiles");
        if (chargedProjectiles != null && !chargedProjectiles.getValue().isEmpty()) {
            CompoundTag javaProjectileAsNbt = (CompoundTag)chargedProjectiles.getValue().get(0);
            ItemMapping projectileMapping = session.getItemMappings().getMapping((String)((Tag)javaProjectileAsNbt.get("id")).getValue());
            if (projectileMapping == null) {
                return;
            }
            @Nullable CompoundTag projectileTag = (CompoundTag)javaProjectileAsNbt.get("tag");
            ItemStack itemStack = new ItemStack(projectileMapping.getJavaItem().javaId(), ((Byte)((Tag)javaProjectileAsNbt.get("Count")).getValue()).byteValue(), projectileTag);
            ItemData itemData = ItemTranslator.translateToBedrock(session, itemStack);
            CompoundTag newProjectile = new CompoundTag("chargedItem");
            newProjectile.put(new ByteTag("Count", (byte)itemData.getCount()));
            newProjectile.put(new StringTag("Name", projectileMapping.getBedrockIdentifier()));
            newProjectile.put(new ShortTag("Damage", (short)itemData.getDamage()));
            tag.put(newProjectile);
        }
    }

    @Override
    public void translateNbtToJava(@NonNull CompoundTag tag, @NonNull ItemMapping mapping) {
        super.translateNbtToJava(tag, mapping);
        if (tag.get("chargedItem") != null) {
            CompoundTag chargedItem = (CompoundTag)tag.get("chargedItem");
            CompoundTag newProjectile = new CompoundTag("");
            newProjectile.put(new ByteTag("Count", (Byte)((Tag)chargedItem.get("Count")).getValue()));
            newProjectile.put(new StringTag("id", (String)((Tag)chargedItem.get("Name")).getValue()));
            ListTag chargedProjectiles = new ListTag("ChargedProjectiles");
            chargedProjectiles.add(newProjectile);
            tag.put(chargedProjectiles);
        }
    }
}

