/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.github.steveice10.opennbt.tag.builtin.ByteArrayTag;
import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntArrayTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.FireworkColor;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.MathUtils;

public class FireworkRocketItem
extends Item {
    public FireworkRocketItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateNbtToBedrock(@NonNull GeyserSession session, @NonNull CompoundTag tag) {
        ListTag explosions;
        super.translateNbtToBedrock(session, tag);
        CompoundTag fireworks = (CompoundTag)tag.get("Fireworks");
        if (fireworks == null) {
            return;
        }
        if (fireworks.get("Flight") != null) {
            fireworks.put(new ByteTag("Flight", MathUtils.getNbtByte(((Tag)fireworks.get("Flight")).getValue())));
        }
        if ((explosions = (ListTag)fireworks.get("Explosions")) == null) {
            return;
        }
        Iterator iterator = explosions.getValue().iterator();
        while (iterator.hasNext()) {
            Tag effect = (Tag)iterator.next();
            CompoundTag effectData = (CompoundTag)effect;
            CompoundTag newEffectData = FireworkRocketItem.translateExplosionToBedrock(effectData, "");
            explosions.remove(effectData);
            explosions.add(newEffectData);
        }
    }

    @Override
    public void translateNbtToJava(@NonNull CompoundTag tag, @NonNull ItemMapping mapping) {
        super.translateNbtToJava(tag, mapping);
    }

    static CompoundTag translateExplosionToBedrock(CompoundTag explosion, String newName) {
        int i;
        byte[] colors;
        int[] oldColors;
        CompoundTag newExplosionData = new CompoundTag(newName);
        if (explosion.get("Type") != null) {
            newExplosionData.put(new ByteTag("FireworkType", MathUtils.getNbtByte(((Tag)explosion.get("Type")).getValue())));
        }
        if (explosion.get("Colors") != null) {
            oldColors = (int[])((Tag)explosion.get("Colors")).getValue();
            colors = new byte[oldColors.length];
            i = 0;
            for (int color : oldColors) {
                colors[i++] = FireworkColor.fromJavaRGB(color);
            }
            newExplosionData.put(new ByteArrayTag("FireworkColor", colors));
        }
        if (explosion.get("FadeColors") != null) {
            oldColors = (int[])((Tag)explosion.get("FadeColors")).getValue();
            colors = new byte[oldColors.length];
            i = 0;
            for (int color : oldColors) {
                colors[i++] = FireworkColor.fromJavaRGB(color);
            }
            newExplosionData.put(new ByteArrayTag("FireworkFade", colors));
        }
        if (explosion.get("Trail") != null) {
            newExplosionData.put(new ByteTag("FireworkTrail", MathUtils.getNbtByte(((Tag)explosion.get("Trail")).getValue())));
        }
        if (explosion.get("Flicker") != null) {
            newExplosionData.put(new ByteTag("FireworkFlicker", MathUtils.getNbtByte(((Tag)explosion.get("Flicker")).getValue())));
        }
        return newExplosionData;
    }

    static CompoundTag translateExplosionToJava(CompoundTag explosion, String newName) {
        int i;
        int[] colors;
        byte[] oldColors;
        CompoundTag newExplosionData = new CompoundTag(newName);
        if (explosion.get("FireworkType") != null) {
            newExplosionData.put(new ByteTag("Type", MathUtils.getNbtByte(((Tag)explosion.get("FireworkType")).getValue())));
        }
        if (explosion.get("FireworkColor") != null) {
            oldColors = (byte[])((Tag)explosion.get("FireworkColor")).getValue();
            colors = new int[oldColors.length];
            i = 0;
            for (byte color : oldColors) {
                colors[i++] = FireworkColor.fromBedrockId(color);
            }
            newExplosionData.put(new IntArrayTag("Colors", colors));
        }
        if (explosion.get("FireworkFade") != null) {
            oldColors = (byte[])((Tag)explosion.get("FireworkFade")).getValue();
            colors = new int[oldColors.length];
            i = 0;
            for (byte color : oldColors) {
                colors[i++] = FireworkColor.fromBedrockId(color);
            }
            newExplosionData.put(new IntArrayTag("FadeColors", colors));
        }
        if (explosion.get("FireworkTrail") != null) {
            newExplosionData.put(new ByteTag("Trail", MathUtils.getNbtByte(((Tag)explosion.get("FireworkTrail")).getValue())));
        }
        if (explosion.get("FireworkFlicker") != null) {
            newExplosionData.put(new ByteTag("Flicker", MathUtils.getNbtByte(((Tag)explosion.get("FireworkFlicker")).getValue())));
        }
        return newExplosionData;
    }
}

