/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntArrayTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.item.type.FireworkRocketItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;

public class FireworkStarItem
extends Item {
    public FireworkStarItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateNbtToBedrock(@NonNull GeyserSession session, @NonNull CompoundTag tag) {
        super.translateNbtToBedrock(session, tag);
        Object explosion = tag.remove("Explosion");
        if (explosion instanceof CompoundTag) {
            CompoundTag newExplosion = FireworkRocketItem.translateExplosionToBedrock((CompoundTag)explosion, "FireworksItem");
            tag.put(newExplosion);
            Object color = ((CompoundTag)explosion).get("Colors");
            if (color instanceof IntArrayTag) {
                int finalColor;
                int[] colors = ((IntArrayTag)color).getValue();
                if (colors.length == 0) {
                    return;
                }
                if (colors.length == 1) {
                    finalColor = colors[0];
                } else {
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    for (int fireworkColor : colors) {
                        r += (fireworkColor & 0xFF0000) >> 16;
                        g += (fireworkColor & 0xFF00) >> 8;
                        b += fireworkColor & 0xFF;
                    }
                    finalColor = (r /= colors.length) << 16 | (g /= colors.length) << 8 | (b /= colors.length);
                }
                tag.put(new IntTag("customColor", finalColor));
            }
        }
    }

    @Override
    public void translateNbtToJava(@NonNull CompoundTag tag, @NonNull ItemMapping mapping) {
        super.translateNbtToJava(tag, mapping);
        Object explosion = tag.remove("FireworksItem");
        if (explosion instanceof CompoundTag) {
            CompoundTag newExplosion = FireworkRocketItem.translateExplosionToJava((CompoundTag)explosion, "Explosion");
            tag.put(newExplosion);
        }
        tag.remove("customColor");
    }
}

