/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.item.components.ToolTier;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;

public class ShieldItem
extends Item {
    public ShieldItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateNbtToBedrock(@NonNull GeyserSession session, @NonNull CompoundTag tag) {
        super.translateNbtToBedrock(session, tag);
        Object t = tag.remove("BlockEntityTag");
        if (t instanceof CompoundTag) {
            CompoundTag blockEntityTag = (CompoundTag)t;
            Object object = blockEntityTag.get("Patterns");
            if (object instanceof ListTag) {
                ListTag patterns = (ListTag)object;
                object = patterns.iterator();
                while (object.hasNext()) {
                    Tag pattern = (Tag)object.next();
                    Object t2 = ((CompoundTag)pattern).get("Color");
                    if (!(t2 instanceof IntTag)) continue;
                    IntTag color = (IntTag)t2;
                    color.setValue(15 - color.getValue());
                }
                tag.put(patterns);
            }
            if ((object = blockEntityTag.get("Base")) instanceof IntTag) {
                IntTag base = (IntTag)object;
                base.setValue(15 - base.getValue());
                tag.put(base);
            }
        }
    }

    @Override
    public boolean isValidRepairItem(Item other) {
        return ToolTier.WOODEN.getRepairIngredients().contains(other);
    }
}

