/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.item.type.WritableBookItem;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.NamedTextColor;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.TextColor;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.text.MessageTranslator;

public class WrittenBookItem
extends WritableBookItem {
    public static final int MAXIMUM_PAGE_EDIT_LENGTH = 1024;
    public static final int MAXIMUM_PAGE_LENGTH = 32768;
    public static final int MAXIMUM_PAGE_COUNT = 100;
    public static final int MAXIMUM_TITLE_LENGTH = 16;

    public WrittenBookItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateNbtToBedrock(@NonNull GeyserSession session, @NonNull CompoundTag tag) {
        boolean isValid = this.isValidWrittenBook(tag);
        if (!isValid) {
            tag.remove("pages");
        }
        super.translateNbtToBedrock(session, tag);
        if (!isValid) {
            CompoundTag invalidTagPage = new CompoundTag("");
            invalidTagPage.put(new StringTag("photoname", ""));
            invalidTagPage.put(new StringTag("text", MessageTranslator.convertMessage(Component.translatable("book.invalid.tag", (TextColor)NamedTextColor.DARK_RED), session.locale())));
            tag.put(new ListTag("pages", List.of(invalidTagPage)));
        }
    }

    private boolean isValidWrittenBook(CompoundTag tag) {
        Object t = tag.get("title");
        if (!(t instanceof StringTag)) {
            return false;
        }
        StringTag title = (StringTag)t;
        if (title.getValue().length() > 32) {
            return false;
        }
        if (!(tag.get("author") instanceof StringTag)) {
            return false;
        }
        Object object = tag.get("pages");
        if (!(object instanceof ListTag)) {
            return false;
        }
        ListTag pages = (ListTag)object;
        for (Tag pageTag : pages) {
            StringTag page;
            if (!(pageTag instanceof StringTag) || (page = (StringTag)pageTag).getValue().length() <= 32768) continue;
            return false;
        }
        return true;
    }
}

